% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{race_data}
\alias{race_data}
\title{Horse Race Data}
\format{A \code{data.frame} object with 36,418 observations and 19 columns. 

The columns are defined as follows:
\describe{
\item{\code{EventId}}{An integer ID denoting the event (race). These range from 1 to 4486.}
\item{\code{TrackId}}{An integer ID number of the the track. There are 64
different tracks represented.}
\item{\code{Type}}{The type of event, one of \dQuote{Thoroughbred} or \dQuote{Harness}.}
\item{\code{RaceNum}}{The integer race number within a group of races at a track on a given date.}
\item{\code{CorrectedPostTime}}{The \sQuote{corrected} post time of the race, in the form \code{\%Y-\%m-\%d \%H:\%M:\%S},
presumably in the PDT time zone. Has values like \dQuote{2019-03-05 02:30:00}.}
\item{\code{Yards}}{The length of the race, in yards.}
\item{\code{SurfaceText}}{A string, one of 
\dQuote{Turf}, \dQuote{Dirt}, \dQuote{All-Weather} or \code{NA}.}
\item{\code{HorseName}}{The string name of the horse.}
\item{\code{HorseId}}{A unique integer ID for each horse. As different horses can have the same name, this ID is constructed from the name 
of the Horse, the Sire and the Dam.}
\item{\code{Age}}{The age of the horse, in integer years, at the time of the event.
Typically less than 10.}
\item{\code{Sex}}{A single character denoting the sex of the horse. I
believe the codes are 
\dQuote{M} for \dQuote{Mare} (female four years or older), 
\dQuote{G} for \dQuote{Gelding},
\dQuote{F} for \dQuote{Filly} (female under four years of age),
\dQuote{C} for \dQuote{Colt} (male under four years of age),
\dQuote{H} for \dQuote{Horse} (male four years of age and up),
\dQuote{R} for \dQuote{Rig} (hard to explain),
\dQuote{A} for \dQuote{???}. There are some \code{NA} values as well.}
\item{\code{Weight_lbs}}{The weight in integer pounds of the jockey and any equipment. Typically around 120.}
\item{\code{PostPosition}}{The integer starting position of the horse.
Typically there is a slight advantage to starting at the first or second
post position.}
\item{\code{Medication}}{One of several codes indicating any medication the horse may
be taking at the time of the race. I believe \dQuote{L} stands for
\dQuote{Lasix}, a common medication for lung conditions that is thought to give
horses a slight boost in speed.}
\item{\code{MorningLine}}{A double indicating the \dQuote{morning betting line} for
win bets on the horse. It is not clear how to interpret this value, perhaps
it is return on a dollar. Values range from 0.40 to 80.}
\item{\code{WN_pool}}{The total combined pool in win bets, in dollars, on
this horse at post time.}
\item{\code{PL_pool}}{The total combined pool in place bets, in dollars, on
this horse at post time.}
\item{\code{SH_pool}}{The total combined pool in show bets, in dollars, on
this horse at post time.}
\item{\code{Finish}}{The integer finishing position of the horse. A 1 means first place. We only collect values of 1, 2, and 3, while
the remaining finishing places are unknown and left as \code{NA}.}
}}
\source{
Data were sourced from the web. Don't ask.
}
\usage{
data(race_data)
}
\description{
Three weeks of horse race data from tracks worldwide.
}
\note{
The author makes no guarantees regarding correctness of this data.
}
\examples{

library(dplyr)
data(race_data)

# compute win bet efficiency
efficiency <- race_data \%>\%
  group_by(EventId) \%>\%
    mutate(ImpliedOdds=WN_pool / sum(WN_pool,na.rm=TRUE)) \%>\%
  ungroup() \%>\%
  mutate(OddsBucket=cut(ImpliedOdds,c(0,0.05,seq(0.1,1,by=0.10)),include.lowest=TRUE)) \%>\%
  group_by(OddsBucket) \%>\%
    summarize(PropWin=mean(as.numeric(coalesce(Finish==1,FALSE)),na.rm=TRUE),
              MedImpl=median(ImpliedOdds,na.rm=TRUE),
              nObs=n()) \%>\%
  ungroup()

\donttest{
if (require('ggplot2') && require('scales')) {
  efficiency \%>\%
    ggplot(aes(MedImpl,PropWin,size=nObs)) + 
    geom_point() + 
    scale_x_sqrt(labels=percent) + 
    scale_y_sqrt(labels=percent) + 
    geom_abline(slope=1,intercept=0,linetype=2,alpha=0.6) + 
    labs(title='actual win probability versus implied win probability',
         size='# horses',
         x='implied win probability',
         y='observed win probability')
 }
}

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{data}
