% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oes_plot.R
\name{oes_plot}
\alias{oes_plot}
\title{Create OES Plot}
\usage{
oes_plot(
  prep,
  font = "sans",
  device = "pdf",
  treatment_fill = "#F2C446",
  control_fill = "#2E9AC4",
  digits = 3,
  report_stars = TRUE,
  xlab,
  ylab,
  title = "Outcomes under Treatment",
  save = FALSE,
  name_save = "figure1.png",
  base_size = 12,
  width = 3.1,
  height = 4,
  dpi_forplot = 300
)
}
\arguments{
\item{prep}{A tidy tibble of estimates to plot, such as the output from
\code{oes_prep()}.}

\item{font}{Optional string giving font; defaults to \code{"sans"}.}

\item{device}{Set device for loading fonts. Default is \code{"pdf"}.}

\item{treatment_fill}{Bar color for treatment conditions.}

\item{control_fill}{Bar color for control condition.}

\item{digits}{Integer representing number of digits after decimal point to
report. Defaults to 3.}

\item{report_stars}{Logical indicating whether to display asterisks for statistical
significance. Defaults to \code{TRUE}.}

\item{xlab}{String providing the \eqn{x}-axis label.}

\item{ylab}{String providing the \eqn{y}-axis label.}

\item{title}{String providing the plot title.}

\item{save}{Logical indicating whether to save the plot. Defaults to
\code{FALSE}. If \code{TRUE}, the plot is not returned, but a file is saved using \code{ggsave}.}

\item{name_save}{File name for saved plot.}

\item{base_size}{Base font size for plot.}

\item{width}{Width of saved plot (in inches). Use 6.8 for multiple columns.}

\item{height}{Height of saved plot (in inches).}

\item{dpi_forplot}{Resolution of saved plot.}
}
\value{
A plot; if \code{save = TRUE}, a file containing a plot.
}
\description{
Plot experimental results using OES style
}
\details{
oes_plot plots the observed response mean of a control group and the
predicted response means of one or more
treatment groups based on OES guidance on data reporting and visualization
best-practice. Read more about this OES guidance at
https://oes.gsa.gov/assets/files/reporting-statistical-results.pdf.
}
\examples{

data(df_oes)

# Single binary treatment:
fit <- lm(y1 ~ x1, df_oes)

# Multiple treatment conditions:
fit2 <- lm(y2 ~ x2, df_oes)

# Using HC2 SE's from lm_robust():
fit_robust <- estimatr::lm_robust(y1 ~ x1, df_oes)
fit_robust2 <- estimatr::lm_robust(y2 ~ x2, df_oes)

# Using covariates and lm():
fit_covars <- lm(y2 ~ x2 + z1 + z2 + z3, df_oes)

# Using covariates and lm_robust():
fit_covars_robust <- estimatr::lm_robust(y2 ~ x2 + z1 + z2 + z3, df_oes)

# Specify treatment_arms:
oes_prep(fit, treatment_arms = 1) |> oes_plot()

# Specify treatment_vars:
fit |>
  oes_prep(treatment_vars = "x1") |>
  oes_plot()

# Specify treatment_arms:
oes_prep(fit2, treatment_arms = 3) |>
  oes_plot()

# Specify treatment_vars:
fit2 |>
  oes_prep(treatment_vars = c("x21", "x22", "x23")) |>
  oes_plot()

# Specify custom treatment_labels:
prep_w_labels <- oes_prep(fit2, treatment_arms = 3,
  treatment_labels = c(
    "Email",
    "Email +\nReward",
    "Email +\nRisk"),
  control_label = "Status Quo")

oes_plot(prep_w_labels)

# Using objects from estimatr::lm_robust():
oes_prep(fit_robust, treatment_arms = 1) |> oes_plot()

oes_prep(fit_robust2, treatment_arms = 3) |> oes_plot()

# Specify covariates with lm:
oes_prep(fit_covars, treatment_arms = 3) |> oes_plot()

# Specify covariates with lm_robust():
oes_prep(fit_covars_robust, treatment_arms = 3) |> oes_plot()

# For the Lin estimator, a manual version of lm_lin():
m.mat <- cbind(y2 = df_oes$y2, model.matrix(y2 ~ x2 + z1 + z2 + z3, df_oes)[, -1])
m.mat <- dplyr::mutate_at(
  data.frame(m.mat),
  .vars = c('z1', 'z2', 'z31', 'z32', 'z33', 'z34', 'z35'),
  function(x) x - mean(x)
  )

fit_lin <- estimatr::lm_robust(y2 ~ (x21 + x22 + x23) *
  (z1 + z2 + z31 + z32 + z33 + z34 + z35), m.mat)

oes_prep(fit_lin, treatment_arms = 3) |> oes_plot()

}
\author{
Miles Williams
}
