% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likebut.R
\name{parameters.character}
\alias{parameters.character}
\title{Get Parameters for Character}
\usage{
\method{parameters}{character}(x, simplify = FALSE, ...)
}
\arguments{
\item{x}{object}

\item{simplify}{if x is length one and simplify is TRUE, return a named vector}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Gets parameters, treating character as model names. If x is length one, 
slightly more details are returned such as datafile, reference model, and feature.
Otherwise results are bound together, one model per column.
See \code{\link{estimates}} and \code{\link{errors}} for a more formal interface to model estimates and asymptotic standard errors.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% parameters
}
\seealso{
Other parameters: \code{\link{parameters.numeric}},
  \code{\link{parameters}}
}
