% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_netlogo.R
\name{download_netlogo}
\alias{download_netlogo}
\title{Download NetLogo}
\usage{
download_netlogo(to, version, extract = FALSE)
}
\arguments{
\item{to}{Path to folder where the downloaded file is saved.}

\item{version}{Character string naming which NetLogo Version to download (see Details)}

\item{extract}{TRUE/FALSE, if TRUE downloaded archive is extracted to subfolder of \code{to} (only unix)}
}
\description{
Auxiliary function to download NetLogo
}
\details{
Supported Versions for Download and Usage (parameter \code{version}):
\itemize{
\item "6.1.0" = NetLogo Version 6.1.0
\item "6.0.4" = NetLogo Version 6.0.4
\item "6.0.3" = NetLogo Version 6.0.3
\item "6.0.2" = NetLogo Version 6.0.2
\item "6.0.1" = NetLogo Version 6.0.1
\item "6.0" = NetLogo Version 6.0
\item "5.3.1" = NetLogo Version 5.3.1
}
}
\examples{
\donttest{
dlpath <- tempdir()  # adjust path to your needs
download_netlogo(dlpath, "6.0.3")
}

}
