% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat.R
\name{nlmixr2fix}
\alias{nlmixr2fix}
\title{Try to fix a nlmixr2 fit}
\usage{
nlmixr2fix(fit)
}
\arguments{
\item{fit}{nlmixr2 fit object from a different version of nlmixr2.}
}
\value{
A nlmixr2 fit that has been (possibly) adjusted to work
  with the current version of nlmixr2.
}
\description{
Currently this re-evaluates the function in the current version of rxode2.
}
\examples{

\donttest{

# This is a nlmixr2 v3 fit
fit <- system.file("testfit_nlmixr3.rds", package = "nlmixr2est")
fit <- readRDS(fit)

# While it prints well, it can't be used in all functions because
# Language features (like +var()) are not supported in the v3 version

print(fit)

try(rxSolve(fit)) # should error, but with try it will just display the error

# This function attempts to fix it by regenerating the rxode2 model with the
# new features

# This function also prints out the information on how this fit was created

fit <- nlmixr2fix(fit)

# Now solving and other functions work

rxSolve(fit)

}
}
\author{
Matthew L. Fidler
}
