% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BUGS_macros.R
\name{getMacroParameters}
\alias{getMacroParameters}
\title{EXPERIMENTAL: Get list of parameter names generated by model macros}
\usage{
getMacroParameters(
  model,
  includeLHS = TRUE,
  includeRHS = TRUE,
  includeDeterm = TRUE,
  includeStoch = TRUE,
  includeIndexPars = FALSE
)
}
\arguments{
\item{model}{A NIMBLE model object}

\item{includeLHS}{Include generated parameters on the left-hand side (LHS) of 
assignments (\code{<-} or \code{~}) in the output}

\item{includeRHS}{Include generated parameters on the left-hand side (RHS) of 
assignments (\code{<-} or \code{~}) in the output}

\item{includeDeterm}{Include deterministic generated parameters in the output}

\item{includeStoch}{Include stochastic generated parameters in the output}

\item{includeIndexPars}{Include index parameters generated for use in for loops
in the output}
}
\value{
A named list of generated parameters, with the element names 
corresponding to the original source macro.
}
\description{
Get a list of all parameter names (or certain categories of parameters)
generated by model macros in the model code.
}
\details{
Some model macros will generate new parameters to be included in the
 output code. NIMBLE automatically detects these new parameters and 
 records them in the model object. This function allows easy access
 to this stored list, or subsets of it (see arguments).
}
\examples{
nimbleOptions(enableMacros = TRUE)
nimbleOptions(enableMacroComments = FALSE)
nimbleOptions(verbose = FALSE)

testMacro <- list(process = function(code, modelInfo, .env){
  code <- quote({
    for (i_ in 1:n){
      mu[i_] <- alpha + beta
      y[i_] ~ dnorm(0, sigma)
    }
    alpha ~ dnorm(0, 1)
  })
  list(code = code, modelInfo=modelInfo)
})
 class(testMacro) <- "model_macro"

code <- nimbleCode({
  y[1:n] ~ testMacro()
})

const <- list(y = rnorm(10), n = 10)

mod <- nimbleModel(code, constants=const)

mod$getMacroParameters()
# should be list(testMacro = list(c("mu", "alpha", "beta", "sigma")))

mod$getMacroParameters(includeRHS = FALSE)
# should be list(testMacro = list(c("mu", "alpha")))
}
