% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{msleep}
\alias{msleep}
\title{Sleep Utility}
\usage{
msleep(time)
}
\arguments{
\item{time}{integer number of milliseconds to block the caller.}
}
\value{
Invisible NULL.
}
\description{
Sleep function. May block for longer than requested, with the actual wait
time determined by the capabilities of the underlying system.
}
\details{
Non-integer values for \code{time} are coerced to integer. Negative, logical and
other non-numeric values are ignored, causing the function to return
immediately.

Note that unlike \code{Sys.sleep()}, this function is not user-interruptible by
sending SIGINT e.g. with ctrl + c.
}
\examples{
time <- mclock(); msleep(100); mclock() - time

}
