% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloCovar.R
\name{phyloCovar}
\alias{phyloCovar}
\title{Calculation of Brownian (co)variance using independent contrasts.}
\usage{
phyloCovar(x, phy, estimator = "unbiased")
}
\arguments{
\item{x}{A continuous trait}

\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{estimator}{Should Brownian variance (or covariance) be based on the unbiased ("unbiased" - default) or maximum likelihood ("ML") estimator.}
}
\value{
brownianVariance Brownian variance (or covariance for multiple traits) given the data and phylogeny
}
\description{
Calculates the Brownian variance (single trait) or variance-covariance matrix (mutliple traits) using phylogenetically independent contrasts.
}
\examples{
data(anolis.tree)
data(anolis.data)
## calculate Brownian variance of female SVL
female.svl <- matrix(anolis.data[,"Female_SVL"], 
dimnames=list(rownames(anolis.data)))
input.data <- sortTraitData(phy=anolis.tree, y=female.svl, log.trait=TRUE)
phyloCovar(x=input.data$trait, phy = input.data$phy)
}
\references{
Felsenstein J. 1973. Maximum-likelihood estimation of evolutionary trees from continuous characters. Am. J. Hum. Genet. 25, 471-492.

Felsenstein J. 1985. Phylogenies and the comparative method. American Naturalist 125, 1-15.

Freckleton RP & Jetz W. 2009. Space versus phylogeny: disentangling phylogenetic and spatial signals in comparative data. Proc. Roy. Soc. B 276, 21-30.
}
\author{
Gavin Thomas, Rob Freckleton
}
