% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiscaleMosum_bottomUp.R
\name{multiscale.bottomUp.cpts}
\alias{multiscale.bottomUp.cpts}
\title{Multiscale MOSUM algorithm (bottom-up)}
\usage{
multiscale.bottomUp.cpts(x, G, threshold = c("critical.value", "custom")[1],
  alpha = 0.05, threshold.function = NULL, eta = 0.8, bootstrap = F,
  N_bootstrap, alpha_CI = 0.05, ...)
}
\arguments{
\item{x}{input data (\code{numeric} vector or object of class \code{ts})}

\item{G}{a symmetric bandwidth grid;
either an object of type \code{multiscale.grid} or an integer vector
of bandwidths}

\item{threshold}{string indicating which threshold should be used to determine significance.
By default, \code{mosum.criticalValue} is used for each bandwidth (with significance
level \code{alpha}). Alternatively, it is possible to parse a user-defined function 
with \code{threshold.function};}

\item{alpha}{a numeric value for the significance level with
\code{0 <= alpha <= 1}; use iff \code{threshold="critical.value"}}

\item{threshold.function}{function object of form \code{function(G)}, to compute a
threshold of significance for different bandwidths G; use iff \code{threshold="custom"}}

\item{eta}{see \link[mosum]{mosum.cpts}}

\item{bootstrap}{flag indicating whether bootstrap replicates of estimated changepoints
should be computed}

\item{N_bootstrap}{number of bootstrap replicates to be generated (iff bootstrap)}

\item{alpha_CI}{numeric value in (0,1), such that the (1-alpha_CI)-confidence bootstrap intervals are computed (iff bootstrap)}

\item{...}{further arguments to be passed to the \code{mosum} calls
for respective bandwidths; see \link[mosum]{mosum}}
}
\value{
S3 \code{multiscale.cpts} object, which contains the following fields:
   \item{x}{the numeric input vector provided}
   \item{cpts}{estimated changepoints after merging}
   \item{cpts.info}{data frame containing information about estimated changepoints}
   \item{pooled.cpts}{set of changepoint candidates that have been considered during the algorithm}
   \item{G,eta}{input parameter}
   \item{threshold,threshold.function}{input parameter}
   \item{bootstrap}{input parameter}
   \item{cpts_bootstrap}{bootstrap replicates and CIs, object of class \link[mosum]{cpts.bootstrap} (iff bootstrap)}
}
\description{
Multiscale MOSUM procedure with bottom-up bandwidth based merging
}
\details{
See Algorithm 1 in the first referenced paper for a comprehensive
description of the procedure and further details.
}
\examples{
# many-bandwidth example
x <- piecewiseStationary_timeSeries(lengths=c(50,50,200,300,300), 
  means=c(0,1,2,3,2.3), sds=rep(1,5))
G <- (5:20)*5
mcpts <- multiscale.bottomUp.cpts(x, G, alpha=0.1)
mcpts$pooled.cpts
mcpts$cpts
}
\references{
A. Meier, C. Kirch and H. Cho.
\emph{mosum: A Package for Moving Sums in Change Point Analysis.}
Unpublished manuscript, 2018+.

H. Cho and C. Kirch.
\emph{Multiple change-point detection via multiscale MOSUM procedure with localized pruning.}
Unpublished manuscript, 2018+.

M. Messer et al. 
\emph{A multiple filter test for the detection of rate changes in renewal processes with varying variance.}
Annals of Applied Statistics, 8(4):2027-2067, 2014.
}
