% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/analyses.R
\name{testRelations}
\alias{testRelations}
\title{testRelations}
\usage{
testRelations(data, trait, type, restrict = rep(TRUE, ncol(data)),
  multiple.adjust = "BH", paired = FALSE, debug = FALSE)
}
\arguments{
\item{data}{: frequency matrix with gene_ids in the rownames}

\item{trait}{: a vector with the trait to test, binary or numerical variable}

\item{type}{: a character string indicating the type of test to be applied}

\item{restrict}{: an optional logical vector to select a subset of the samples to perform the test
default restrict = rep(TRUE, ncol(data)) ie all the samples are selected}

\item{multiple.adjust}{: type of multiple adjustment default is "BH" i.e. Benjamini & Hochberg method}

\item{paired}{: logical with default FALSE wether the test should be paired or not}

\item{debug}{: default FALSE, when TRUE the progress is printed each 1000 steps}
}
\value{
a matrix with analytical results (correlation tests) indicating rho, rho2, p and q values for each parameter tested
}
\description{
This function applies a statistical test either a correlation (spearman, pearson),
     wilcoxon or t.test as a function of a given phenotype. It will return a matrix of probabilities
     p and q values along with the correlation coefficient or the enrichment variable when a binary parameter.
}
\details{
\code{testRelations}
}
\note{
New addon taking into account a trait for correlation, when it is a two class variable with the same number of elements
     a correlation between both groups is performed
}
\author{
Edi Prifti & Emmanuelle Le Chatelier
}

