% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSat.R
\name{plotSat}
\alias{plotSat}
\title{Plot observations on satellite image}
\usage{
plotSat(
  data,
  zoom = NULL,
  location = NULL,
  segments = TRUE,
  compact = TRUE,
  col = NULL,
  alpha = 1,
  size = 1,
  shape = 16,
  states = NULL,
  animals = NULL,
  ask = TRUE,
  return = FALSE,
  stateNames = NULL,
  projargs = NULL
)
}
\arguments{
\item{data}{Data frame or \code{\link{momentuHMMData}} object, with necessary fields 'x' (longitudinal direction) and 'y' (latitudinal direction).  A \code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object is also permitted, from which the data will be extracted.
If \code{states=NULL} and a \code{momentuHMM}, \code{miHMM}, or \code{miSum} object is provided, the decoded states are automatically plotted.}

\item{zoom}{The zoom level, as defined for \code{\link[ggmap]{get_map}}. Integer value between
3 (continent) and 21 (building).}

\item{location}{Location of the center of the map to be plotted (this must be in the same coordinate reference system as \code{data}).}

\item{segments}{\code{TRUE} if segments should be plotted between the observations (default),
\code{FALSE} otherwise.}

\item{compact}{\code{FALSE} if tracks should be plotted separately, \code{TRUE}
otherwise (default).}

\item{col}{Palette of colours to use for the dots and segments. If not specified, uses default palette.}

\item{alpha}{Transparency argument for \code{\link[ggplot2]{geom_point}}.}

\item{size}{Size argument for \code{\link[ggplot2]{geom_point}}.}

\item{shape}{Shape argument for \code{\link[ggplot2]{geom_point}}. If \code{states} is provided, then \code{shape} must either be a scalar or a vector of length \code{length(unique(states))}.
If \code{states=NULL}, then \code{shape} must either be a scalar or a vector consisting of a value for each individual to be plotted.}

\item{states}{A sequence of integers, corresponding to the decoded states for these data
(such that the observations are colored by states).}

\item{animals}{Vector of indices or IDs of animals/tracks to be plotted.
Default: \code{NULL}; all animals are plotted.}

\item{ask}{If \code{TRUE}, the execution pauses between each plot.}

\item{return}{If \code{TRUE}, the function returns a ggplot object (which can be edited and
plotted manually). If \code{FALSE}, the function automatically plots the map (default).}

\item{stateNames}{Optional character vector of length \code{max(states)} indicating state names. Ignored unless \code{states} is provided.}

\item{projargs}{A character string of PROJ.4 projection arguments indicating the coordinate reference system for \code{data} and \code{location} coordinates (if not longitude and latitude). A \code{\link[sp]{CRS-class}} object is also permitted. If \code{projargs} is provided, the coordinates will be internally transformed to longitude and latitude for plotting.}
}
\description{
Plot tracking data on a satellite map. This function plots coordinates in longitude
and latitude (not UTM), so if \code{data} coordinates are not provided in longitude and latitude, then the coordinate reference system must be provided using the \code{projargs} argument. This function uses the package \code{ggmap}
to fetch a satellite image from Google. An Internet connection is required to use
this function.
}
\details{
If the plot displays the message "Sorry, we have no imagery here", try a
lower level of zoom.
}
\references{
D. Kahle and H. Wickham. ggmap: Spatial Visualization with ggplot2.
The R Journal, 5(1), 144-161.
URL: http://journal.r-project.org/archive/2013-1/kahle-wickham.pdf
}
