% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb-methods.R
\name{h_construct_model_frame_inputs}
\alias{h_construct_model_frame_inputs}
\title{Construction of Model Frame Formula and Data Inputs}
\usage{
h_construct_model_frame_inputs(
  formula,
  data,
  include,
  include_choice = c("subject_var", "visit_var", "group_var", "response_var"),
  full
)
}
\arguments{
\item{formula}{(\code{mmrm})\cr fit object.}

\item{data}{(\code{data.frame})\cr optional data frame will be
passed to \code{model.frame()} or \code{model.matrix()}.}

\item{include}{(\code{character})\cr specification of variables to include.}

\item{full}{(\code{flag})\cr indicator whether to return full model frame (deprecated).}
}
\value{
A named list with two elements:
\itemize{
\item \code{"formula"}: the formula including the columns requested in the \verb{include=} argument.
\item \code{"data"}: a data frame including all columns needed in the formula.
}
}
\description{
Input formulas are converted from \code{mmrm}-style to a style compatible
with default \code{\link[stats:model.frame]{stats::model.frame()}} and \code{\link[stats:model.matrix]{stats::model.matrix()}} methods.

The full formula is returned so we can construct, for example, the
\code{model.frame()} including all columns as well as the requested subset.
The full set is used to identify rows to include in the reduced model frame.
}
\keyword{internal}
