% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{emp_start}
\alias{emp_start}
\title{Empirical Starting Value}
\usage{
emp_start(
  y_vector,
  x_matrix,
  full_frame,
  visit_var,
  subject_var,
  subject_groups,
  ...
)
}
\arguments{
\item{y_vector}{(\code{numeric}) response variable.}

\item{x_matrix}{(\code{matrix}) design matrix.}

\item{full_frame}{(\code{data.frame}) full data frame used for model fitting.}

\item{visit_var}{(\code{string})\cr visit variable.}

\item{subject_var}{(\code{string})\cr subject id variable.}

\item{subject_groups}{(\code{factor})\cr subject group assignment.}

\item{...}{not used.}
}
\value{
A numeric vector of starting values.
}
\description{
Obtain empirical start value for unstructured covariance
}
\details{
This \code{emp_start} only works for unstructured covariance structure.
It uses linear regression to first obtain the coefficients and use the residuals
to obtain the empirical variance-covariance, and it is then used to obtain the
starting values.
}
