% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocab.R
\name{vocab}
\alias{vocab}
\alias{vocab}
\alias{vocab_update}
\alias{vocab}
\alias{vocab_prune}
\alias{vocab}
\alias{vocab_embed}
\title{Build and manipulate vocabularies}
\usage{
vocab(corpus, ngram = c(1, 1), ngram_sep = "_")

vocab_update(vocab, corpus)

vocab_prune(vocab, max_terms = Inf, term_count_min = 1L,
  term_count_max = Inf, doc_proportion_min = 0, doc_proportion_max = 1,
  doc_count_min = 1L, doc_count_max = Inf, nbuckets = attr(vocab,
  "nbuckets"))

vocab_embed(vocab, embeddings, nbuckets = attr(vocab, "nbuckets"),
  max_in_bucket = 30)
}
\arguments{
\item{corpus}{list of character vectors}

\item{ngram}{a vector of length 2 of the form \code{c(min_ngram, max_ngram)} or a
singleton \code{max_ngram} which is equivalent to \code{c(1L, max_ngram)}.}

\item{ngram_sep}{separator to link terms within ngrams.}

\item{vocab}{\code{data.frame} obtained from a call to \code{\link[=vocab]{vocab()}}.}

\item{max_terms}{max number of terms to preserve}

\item{term_count_min}{keep terms occurring at \emph{least} this many times over
all docs}

\item{term_count_max}{keep terms occurring at \emph{most} this many times over
all docs}

\item{doc_count_min, doc_proportion_min}{keep terms appearing in at \emph{least}
this many docs}

\item{doc_count_max, doc_proportion_max}{keep terms appearing in at \emph{most}
this many docs}

\item{nbuckets}{How many unknown buckets to create along the
remaining terms of the pruned \code{vocab}. All pruned terms will be hashed
into this many buckets and the corresponding statistics (\code{term_count} and
\code{doc_count}) updated.}

\item{embeddings}{embeddings matrix. The terms dimension must be named. If
both \code{\link[=colnames]{colnames()}} and \code{\link[=rownames]{rownames()}} are non-null, dimension with more
elements is considered term-dimension.}

\item{max_in_bucket}{At most this many embedding vectors will be averaged
into each unknown or missing bucket (see details). Lower number results in
faster processing. For large \code{nbuckets} this number might not be
reached due to the finiteness of the \code{embeddings} vocabulary, or even
result in \code{0} embeddings being hashed into a bucket producing \code{[0 0 ...]}
embeddings for some buckets.}
}
\description{
\code{\link[=vocab]{vocab()}} creates a vocabulry from a text corpus; \code{\link[=vocab_update]{vocab_update()}} and
\code{\link[=vocab_prune]{vocab_prune()}}, respectively,  update and prune an existing vocabulary.

\code{\link[=vocab_embed]{vocab_embed()}} subsets a (commonly large) pre-trained
word-vector matrix into a smaller, one vector per term, embedding
matrix.

\code{\link[=vocab_embed]{vocab_embed()}} is commonly used in conjunction with sequence generators
(\code{\link[=timat]{timat()}} and \code{\link[=tiseq]{tiseq()}}). When a term in a corpus is not present in a
vocabulary (aka unknown), it is hashed into one of the \code{nbuckets}
buckets. Embeddings which are hashed into same bucket are averaged to
produce the embedding for that bucket. Maximum number of embeddings to
average per bucket is controled with \code{max_in_bucket} parameter.

Similarly, when a term from the vocabulary is not present in the embedding
matrix (aka missing) \code{max_in_bucket} embeddings are averaged to produce the
missing embedding. Different buckets are used for "missing" and "unknown"
embeddings because \code{nbuckets} can be 0.
}
\examples{
corpus <-
   list(a = c("The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"), 
        b = c("the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog",
              "the", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"))

vocab(corpus)
vocab(corpus, ngram = 3)
vocab(corpus, ngram = c(2, 3))

v <- vocab(corpus)

extra_corpus <- list(extras = c("apples", "oranges"))
v <- vocab_update(v, extra_corpus)
v

vocab_prune(v, max_terms = 7)
vocab_prune(v, term_count_min = 2)
vocab_prune(v, max_terms = 7, nbuckets = 2)

v2 <- vocab_prune(v, max_terms = 7, nbuckets = 2)
enames <- c("the", "quick", "brown", "fox", "jumps")
emat <- matrix(rnorm(50), nrow = 5,
               dimnames = list(enames, NULL))

vocab_embed(v2, emat)
vocab_embed(v2, t(emat)) # automatic detection of the orientation

vembs <- vocab_embed(v2, emat)
all(vembs[enames, ] == emat[enames, ])
}
