% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-crate.R, R/model.R, R/model-h2o.R,
%   R/model-keras.R, R/model-xgboost.R
\name{mlflow_save_model.crate}
\alias{mlflow_save_model.crate}
\alias{mlflow_save_model}
\alias{mlflow_save_model.H2OModel}
\alias{mlflow_save_model.keras.engine.training.Model}
\alias{mlflow_save_model.xgb.Booster}
\title{Save Model for MLflow}
\usage{
\method{mlflow_save_model}{crate}(model, path, model_spec = list(), ...)

mlflow_save_model(model, path, model_spec = list(), ...)

\method{mlflow_save_model}{H2OModel}(model, path, model_spec = list(), conda_env = NULL, ...)

\method{mlflow_save_model}{keras.engine.training.Model}(model, path, model_spec = list(), conda_env = NULL, ...)

\method{mlflow_save_model}{xgb.Booster}(model, path, model_spec = list(), conda_env = NULL, ...)
}
\arguments{
\item{model}{The model that will perform a prediction.}

\item{path}{Destination path where this MLflow compatible model
will be saved.}

\item{model_spec}{MLflow model config this model flavor is being added to.}

\item{...}{Optional additional arguments.}

\item{conda_env}{Path to Conda dependencies file.}
}
\description{
Saves model in MLflow format that can later be used for prediction and serving. This method is
generic to allow package authors to save custom model types.
}
