# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

test_that("w2l_split functions correctly", {
  # Setup test data
  test_dt <- data.table::data.table(
    id = 1:4,
    group = c("A", "A", "B", "B"),
    val1 = c(10, 20, 30, 40),
    val2 = c(100, 200, 300, 400)
  )
  
  test_df <- as.data.frame(test_dt)
  
  # Test basic functionality
  test_that("basic functionality works", {
    # Test with data.table input
    result1 <- w2l_split(test_dt, cols2l = c("val1", "val2"))
    expect_type(result1, "list")
    expect_length(result1, 2)  # One for each value column
    expect_true(all(sapply(result1, data.table::is.data.table)))
    
    # Test with data.frame input
    result2 <- w2l_split(test_df, cols2l = c("val1", "val2"))
    expect_equal(result1, result2)
    
    # Verify content structure
    expect_equal(names(result1[[1]]), c("id", "group", "value"))
    expect_equal(nrow(result1[[1]]), 4)
  })
  
  # Test different parameter combinations
  test_that("parameter combinations work correctly", {
    # Test with by parameter
    result <- w2l_split(test_dt, cols2l = c("val1", "val2"), by = "group")
    expect_length(result, 4)  # 2 value columns × 2 groups
    expect_true(all(grepl("^(val1|val2)_[AB]$", names(result))))
    
    # Test with numeric indices
    result_num <- w2l_split(test_dt, cols2l = c(3, 4), by = 2)
    expect_equal(result, result_num)
    
    # Test with split_type = "df"
    result_df <- w2l_split(test_dt, cols2l = c("val1", "val2"), split_type = "df")
    expect_true(all(sapply(result_df, is.data.frame)))
    
    # Test with NULL cols2l
    result_null <- w2l_split(test_dt, cols2l = NULL, by = "group")
    expect_length(result_null, 2)  # One for each group
    expect_equal(sort(names(result_null)), c("A", "B"))
  })
  
  # Test custom separator
  test_that("custom separator works", {
    result <- w2l_split(test_dt, cols2l = c("val1", "val2"), by = "group", sep = ":")
    expect_true(all(grepl(":", names(result))))
  })
  
  # Test error handling
  test_that("error handling works correctly", {
    # Test invalid input type
    expect_error(
      w2l_split(list(a = 1)),
      "data must be a data.frame or data.table"
    )
    
    # Test invalid cols2l
    expect_error(
      w2l_split(test_dt, cols2l = "nonexistent"),
      "Some columns specified in cols2l are not present in the data"
    )
    
    expect_error(
      w2l_split(test_dt, cols2l = 10),
      "Numeric indices in cols2l are out of bounds"
    )
    
    # Test invalid by
    expect_error(
      w2l_split(test_dt, cols2l = c("val1", "val2"), by = "nonexistent"),
      "Some 'by' columns are not present in the data"
    )
    
    expect_error(
      w2l_split(test_dt, cols2l = c("val1", "val2"), by = 10),
      "Numeric indices in by are out of bounds"
    )
    
    # Test invalid split_type
    expect_error(
      w2l_split(test_dt, cols2l = c("val1", "val2"), split_type = "invalid"),
      "Invalid split_type provided"
    )
    
    # Test missing by when cols2l is NULL
    expect_error(
      w2l_split(test_dt, cols2l = NULL),
      "When cols2l is NULL, by parameter must be provided"
    )
  })
  
  # Test edge cases
  test_that("edge cases are handled correctly", {
    # Single column to split
    result <- w2l_split(test_dt, cols2l = "val1")
    expect_length(result, 1)
    
    # Single group
    result <- w2l_split(test_dt, cols2l = c("val1", "val2"), by = "id")
    expect_length(result, 8)  # 2 value columns × 4 ids
    
    # Empty data
    empty_dt <- test_dt[0,]
    result <- w2l_split(empty_dt, cols2l = c("val1", "val2"))
    expect_length(result, 0)
    expect_true(all(sapply(result, nrow) == 0))
  })
  
  # Test data content
  test_that("split data content is correct", {
    result <- w2l_split(test_dt, cols2l = c("val1", "val2"), by = "group")
    
    # Check values in split datasets
    val1_a <- result[["val1_A"]]
    expect_equal(val1_a$value, c(10, 20))
    
    val2_b <- result[["val2_B"]]
    expect_equal(val2_b$value, c(300, 400))
    
    # Check structure preservation
    expect_true(all(sapply(result, function(x) "value" %in% names(x))))
    expect_true(all(sapply(result, function(x) "id" %in% names(x))))
  })
  
  # Test with multiple grouping variables
  test_that("multiple grouping variables work correctly", {
    # Create test data with multiple grouping variables
    test_dt_multi <- data.table::data.table(
      id = 1:4,
      group1 = c("A", "A", "B", "B"),
      group2 = c("X", "Y", "X", "Y"),
      val1 = c(10, 20, 30, 40),
      val2 = c(100, 200, 300, 400)
    )
    
    result <- w2l_split(test_dt_multi, 
                        cols2l = c("val1", "val2"), 
                        by = c("group1", "group2"))
    
    expect_length(result, 8)  # 2 value columns × 2 group1 × 2 group2
    expect_true(all(grepl("^val[12]_[AB]_[XY]$", names(result))))
  })
})
