% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_forestable.R
\name{parse_forestable}
\alias{parse_forestable}
\title{Parse forestable}
\usage{
parse_forestable(
  x,
  keepSpeciesCodes = TRUE,
  filterMissingSpecies = TRUE,
  filterDeadTrees = TRUE,
  filterCutTrees = TRUE,
  keepUnfilteredCopy = FALSE,
  minimumTreeDBH = 0.1,
  progress = FALSE
)
}
\arguments{
\item{x}{A data frame or sf object issued from package forestables.}

\item{keepSpeciesCodes}{Keeps forest inventory species codes.}

\item{filterMissingSpecies}{If TRUE, filters out records where species is missing.}

\item{filterDeadTrees}{If TRUE, filters out dead trees (Spanish forest inventory IFN3 or IFN4).}

\item{filterCutTrees}{If TRUE, filters out cut trees (Spanish forest inventory IFN3 or IFN4).}

\item{keepUnfilteredCopy}{If TRUE, an additional column is given where dead/cut trees have not been filtered.}

\item{minimumTreeDBH}{Minimum DBH for keeping a tree record.}

\item{progress}{A logical flag to include a progress bar while processing the data.}
}
\value{
An sf object including a 'forest' column. If \code{keepUnfilteredCopy=TRUE} an additional column 'forest_unfiltered' is also given.
}
\description{
Transforms a data frame or sf object issued from package forestables into an sf object
for simulations with medfateland.
}
\details{
This function retrieves the following information from the forestables object:
\itemize{
\item{Id unique code, survey year, non-unique plot code and country.}
\item{Plot location. Output geometry is always points in WGS 84. Note that exact coordinates are not normally given in forest inventory data.}
\item{Elevation, slope and aspect, whenever available}
\item{Tree and understory data. The function will create a column \code{forest} with this information. If both tree and understory data are
missing for a given row, the corresponding \code{forest} will be empty.}
}
}
