% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_module_step.R
\name{process_module_step}
\alias{process_module_step}
\title{Process Module Steps with Complex KO String Handling}
\usage{
process_module_step(
  module_abundance,
  KO_string = "K03388,K03389+K03390+K14083,K14126+K14127,K14128",
  aggregrate_rowname = "bracket_1",
  step_count = 1,
  plus_scale_method,
  comma_scale_method
)
}
\arguments{
\item{module_abundance}{Data frame containing KO abundance data}

\item{KO_string}{String representation of KO relationships (default: "K03388,K03389+K03390+K14083,K14126+K14127,K14128")}

\item{aggregrate_rowname}{Base name for row aggregation (default: 'bracket_1')}

\item{step_count}{Counter for processing steps (default: 1)}

\item{plus_scale_method}{Scaling method for plus-separated KOs ("mean", "min", or "max")}

\item{comma_scale_method}{Scaling method for comma-separated KOs ("sum" or "max")}
}
\value{
List containing:
- abundance_table: Processed abundance values
- step_count: Updated step counter
- abundance_log: log
}
\description{
Processes a KO string containing various combinations of KOs separated by
different operators (commas, plus signs, or spaces). Handles complex pathway
definitions with multiple types of relationships between KOs.
}
