% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holey_path.r
\name{holey_path}
\alias{holey_path}
\title{holey_path .}
\usage{
holey_path(unit_len, lengths, angles, draw_line = TRUE, has_hole = FALSE,
  hole_color = NULL, hole_locations = NULL, hole_arrows = FALSE)
}
\arguments{
\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{lengths}{an array of the number of units
each part of the path. An array of length \code{n}.}

\item{angles}{after each part of the path is
drawn, the turtle turns right by the given angle.}

\item{draw_line}{a boolean array telling whether
each part of the path is drawn at all, or whether
the turtle simply moves through that path.}

\item{has_hole}{a boolean array telling whether,
conditional on the path being drawn, it has a one unit
hole.}

\item{hole_color}{the color to plot the \sQuote{hole}. 
A value \code{NULL} or \code{'clear'} corresponds to no 
drawn hole, the latter being useful for mixing drawn colored
holes with no hole drawn at all (for which \code{'white'}
would be an acceptable choice if the background were white).
Filled holes are often useful for indicating the entry and
exit points of a maze.
See the \code{\link[grDevices]{colors}} function for
acceptable values.}

\item{hole_locations}{an optional array of \sQuote{locations}
of the holes. These affect the \code{which_seg} of any holey
lines which are drawn. If an array of numeric values,
a value of zero corresponds to allowing the code to randomly
choose the location of a hole; 
negative values are \sQuote{inverted} by adding \code{length + 1}, 
so that if the same segment is drawn twice, in different 
directions, only the sign of the hole location needs to be 
flipped to have aligned holes.
\code{NA} values will throw an error for now, though
this may change in the future.}

\item{hole_arrows}{a boolean or boolean array telling whether
to draw a perpendicular arrow at a hole.}
}
\value{
nothing; the function is called for side effects only, though in
the future this might return information about the drawn boundary of
the shape.
}
\description{
Make the turtle move multiple units, making turns, and possibly drawing
line segments possibly with holes in them.
}
\details{
Causes the turtle to move through a path of connected line segments,
possibly drawing lines, possibly drawing holes in those lines.
All arguments are recycled to the length of the longest
argument via \code{mapply}, which simplifies
the path description.
}
\examples{

library(TurtleGraphics)
# draw a triangle with holes on the boundaries
turtle_init(1000,1000)
holey_path(unit_len=20, lengths=rep(10,3), angles=c(120), draw_line=TRUE, has_hole=TRUE)

# draw a square with holes on the boundaries
turtle_init(1000,1000)
turtle_hide()
holey_path(unit_len=20, lengths=rep(10,4), angles=c(90), draw_line=TRUE, has_hole=TRUE, 
  hole_color=c('red','green'))

# draw a square spiral
turtle_init(1000,1000)
turtle_hide()
holey_path(unit_len=20, lengths=sort(rep(1:10,2),decreasing=TRUE), angles=c(90), 
  draw_line=TRUE, has_hole=FALSE)
}
\seealso{
\code{\link{holey_line}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
