% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{model_description}
\alias{model_description}
\alias{name}
\alias{describe}
\alias{market_type}
\alias{name,market_model-method}
\alias{describe,market_model-method}
\alias{market_type,market_model-method}
\alias{name,market_fit-method}
\alias{describe,market_fit-method}
\alias{market_type,market_fit-method}
\title{Short model and market descriptions}
\usage{
name(object)

describe(object)

market_type(object)

\S4method{name}{market_model}(object)

\S4method{describe}{market_model}(object)

\S4method{market_type}{market_model}(object)

\S4method{name}{market_fit}(object)

\S4method{describe}{market_fit}(object)

\S4method{market_type}{market_fit}(object)
}
\arguments{
\item{object}{A model object.}
}
\value{
\subsection{\code{name}}{The model's name.}

\subsection{\code{describe}}{The model's description.}

\subsection{\code{market_type}}{The model's market type.}
}
\description{
\subsection{\code{name}}{A unique identifying string for the model.}

\subsection{\code{describe}}{A short (one-liner) description of the market model.}

\subsection{\code{market_type}}{
A market type string (equilibrium or disequilibrium) for a given model.}
}
\section{Functions}{
\itemize{
\item \code{name()}: Model name

\item \code{describe()}: Model description

\item \code{market_type()}: Market type

}}
\examples{
# initialize the equilibrium using the houses dataset
model <- new(
  "diseq_basic", # model type
  subject = ID, time = TREND, quantity = HS, price = RM,
  demand = RM + TREND + W + CSHS + L1RM + L2RM + MONTH,
  supply = RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses()
)

# model name
name(model)
# model description
describe(model)
# market type
market_type(model)
}
