% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractRaster.R
\name{extractRaster}
\alias{extractRaster}
\title{Extract pixel values from MAP rasters using point coordinates.}
\usage{
extractRaster(df = NULL, csv_path = NULL, surface = "PfPR2-10",
  year = rep(NA, length(surface)))
}
\arguments{
\item{df}{data.frame containing coordinates of input point locations, must contain columns named 'latitude'/'lat'/'x'  AND 'longitude'/'long'/'y')}

\item{csv_path}{(optional) user-specified path to which extractRaster coordinates and results are stored. If not specified, tempdir() is used instead.}

\item{surface}{string containing 'title' of desired raster(s), e.g. \code{c("raster1", "raster2")}. Defaults to "PfPR2-10" - the most recent global raster of PfPR 2-10.
Check \code{\link{listRaster}} to find titles of available rasters.}

\item{year}{default = \code{rep(NA, length(surface))}; for time-varying rasters: if downloading a single surface for one or more years, \code{year} should be a vector specifying the desired year(s). if downloading more than one surface, use a list the same length as \code{surface}, providing the desired year-range for each time-varying surface in \code{surface} or \code{NA} for static rasters.}
}
\value{
\code{getPR} returns the input dataframe (\code{df}), with the following columns apprended, providing raster values for each surface, location and year.

\enumerate{
\item \code{layer} raster code corresponding to extracted raster values for a given row, check \code{\link{listRaster}} for raster metadata.
\item \code{year} the year for which raster values were extraced (time-varying rasters only; static rasters do not have this column).
\item \code{value} the raster value for the pixel in which a given point location falls.
}
}
\description{
\code{extractRaster} extracts pixel values from MAP rasters at user-specified point locations (without downloading the entire raster).
}
\examples{
#Download PfPR data for Nigeria and Cameroon and map the locations of these points using autoplot
\donttest{
NGA_CMR_PR <- getPR(country = c("Nigeria", "Cameroon"), species = "Pf")
autoplot(NGA_CMR_PR)

#Download PfPR data for Madagascar and map the locations of these points using autoplot
Madagascar_pr <- getPR(ISO = "MDG", species = "Pv")
autoplot(Madagascar_pr)

getPR(country = "ALL", species = "BOTH")
}


}
\seealso{
\code{autoplot} method for quick mapping of PR point locations (\code{\link{autoplot.pr.points}}).
}
