% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connected_components.R
\name{connected_components}
\alias{connected_components}
\title{Connected-Component Labeling}
\usage{
connected_components(las, res, min_pts, name = "clusterID", connectivity = 6)
}
\arguments{
\item{las}{A LAS object representing the point cloud data.}

\item{res}{Grid resolution. If two non-empty voxels are contiguous, they are considered part of
the same component.}

\item{min_pts}{Minimum number of points in a cluster. If a cluster contains fewer than \code{min_pts}
points, it is assigned an ID of 0, indicating that it does not belong to any group.}

\item{name}{A string specifying the name of the new attribute used to store the ID of each cluster.}

\item{connectivity}{integer. 6, 18 or 26 neighbors search.}
}
\value{
A LAS object with an additional attribute named as specified by \code{name}.
}
\description{
Assigns an ID to each cluster of connected components in a point cloud. The point cloud is subdivided
into a 3D grid, and a classical Connected-Component Labeling algorithm is applied in 3D.
}
