% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptSync.R
\name{reptSync}
\alias{reptSync}
\title{Synchronize Species Names Using The Reptile Database}
\usage{
reptSync(
  x,
  solveAmbiguity = TRUE,
  cores = max(1L, floor(parallel::detectCores()/2)),
  showProgress = TRUE,
  getLink = FALSE
)
}
\arguments{
\item{x}{A character vector of taxon names to be matched (e.g., species lists, phylogenetic tip labels, or trait table entries).}

\item{solveAmbiguity}{Logical. If \code{TRUE}, attempts to resolve ambiguous names by retrieving all possible valid species to which the query may refer. Default is \code{TRUE}.}

\item{cores}{Integer. Number of CPU cores to use for parallel processing. Default is half of available cores (min = 1).}

\item{showProgress}{Logical. If \code{TRUE}, displays progress updates during processing. Default is \code{TRUE}.}

\item{getLink}{Logical. If \code{TRUE}, retrieves searched species URLs. Defaults if \code{FALSE}.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{query}: the original input names.
\item \code{RDB}: the best-matching valid names according to The Reptile Database.
\item \code{status}: a status label indicating the result of the match (\code{"up_to_date"}, \code{"updated"}, \code{"ambiguous"}, or \code{"not_found"}).
\item \code{url}: Optional, if getLink = TRUE returns the URL of the species page retrieved for each match, or a list of possible matches if ambiguous.
}
}
\description{
Queries a list of species names through \code{reptSearch()} and returns a data frame with the currently valid names and taxonomic status for each input.
}
\note{
\code{reptSync()} does not make authoritative taxonomic decisions. It matches input names against currently accepted names in The Reptile Database (RDB).
A name marked as \code{"up_to_date"} may still refer to a taxon that has been split, and thus may not reflect the most recent population-level taxonomy.

For ambiguous names, the \code{url} field may contain multiple links corresponding to all valid species to which the queried name is considered a synonym.

See package vignettes for more details.
}
\examples{
query <- c("Vieira-Alencar authoristicus", "Boa atlantica", "Boa diviniloqua", "Boa imperator")

\donttest{
reptSync(x = query, cores = 2)
}

}
\references{
Liedtke, H. C. (2018). AmphiNom: an amphibian systematics tool. \emph{Systematics and Biodiversity}, 17(1), 1–6. https://doi.org/10.1080/14772000.2018.1518935
}
