% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_kindist.R
\name{sample_kindist}
\alias{sample_kindist}
\title{Subsample and filter a KinPairSimulation Object}
\usage{
sample_kindist(
  kindist,
  upper = NULL,
  lower = NULL,
  spacing = NULL,
  n = NULL,
  dims = NULL
)
}
\arguments{
\item{kindist}{KinPairSimulation - KinPairSimulation Class Object}

\item{upper}{numeric - upper cutoff for kin pair distances}

\item{lower}{numeric - lower cutoff for kin pair distances}

\item{spacing}{numeric - spacing between traps (assume 1D layout)}

\item{n}{numeric - number of individuals to keep after filtering (if possible)}

\item{dims}{dimensions to sample within (works with the KinPairSimulation spatial & dimension information). Either 'num' (square) or 'c(num1, num2)' (rectangle).}
}
\value{
returns an object of class 'KinPairSimulation' containing simulation and filtering details and a tibble (tab) of filtered simulation values
}
\description{
This function takes a pre-existing KinPairSimulation Object with distance and coordinate data and filters it to simulate various in-field sampling schemes.
}
\examples{
simobject <- simulate_kindist_simple(nsims = 100000, sigma = 100, kinship = "PO")

sample_kindist(simobject, upper = 200, lower = 50, spacing = 15, n = 100)
}
