% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\name{KinPairSimulation_custom}
\alias{KinPairSimulation_custom}
\title{Constructor for KinPairSimulation Class (custom)}
\usage{
KinPairSimulation_custom(
  data = NULL,
  kinship = NULL,
  kerneltype = NULL,
  customsigma = NULL,
  simdims = NULL,
  lifestage = NULL,
  kernelshape = NULL,
  cycle = NULL,
  call = NULL,
  model = NULL
)
}
\arguments{
\item{data}{tibble of pairwise kin classes & distances. Ideally contains fields id1 & id2 (chr) an distance (dbl) optionally includes coords (x1, y1, x2, y2), lifestage (ls1 & ls2), kinship (chr) and sims (dbl)}

\item{kinship}{character. Code for kinship category of simulation. one of PO, FS, HS, AV, GG, HAV, GGG, 1C, 1C1, 2C, GAV, HGAV, H1C or H2C}

\item{kerneltype}{character. Statistical model for simulated dispersal kernel. Currently either "Gaussian", "Laplace" or "vgamma" (variance-gamma).}

\item{customsigma}{numeric. Named vector of custom breeding cycle stages and their corresponding axial dispersal values}

\item{simdims}{numeric. Length of side of simulated area square.}

\item{lifestage}{character. Simulated lifestage of sampling. Here, must correspond to a custom lifestage derived from 'customsigma'}

\item{kernelshape}{numeric. Value of shape parameter for simulated kernel if kernel requires one (e.g. vgamma kernel).}

\item{cycle}{non-negative integer. Breeding cycle numbers of dispersed kin to be modeled.  Represents
the number of complete breeding cycles each simulated individual has undergone before the sampling point, where the time between
birth and first reproduction is coded as '0', that between first and second reproduction '1', etc. (default 0)}

\item{call}{call object. Use to pass the system call that led to the generation of this class. (via sys.call)}

\item{model}{DispersalModel - model information passed from simulation function}
}
\value{
Returns a \code{KinPairSimulation} Class object with simtype set to 'custom' and relevant fields included.
}
\description{
Constructor for KinPairSimulation Class (custom)
}
\examples{
kindata <- tibble::tibble(
  id1 = c("a", "b", "c"), id2 = c("x", "y", "z"),
  distance = c(50, 45, 65), kinship = c("1C", "1C", "1C")
)
KinPairSimulation_custom(kindata,
  kinship = "1C", kerneltype = "Gaussian",
  customsigma = c(initsigma = 15, breedsigma = 25, gravsigma = 20, ovisigma = 10),
  lifestage = "ovisigma", cycle = 0
)
}
