% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_mean_relative_error}
\alias{metric_mean_relative_error}
\title{Computes the mean relative error by normalizing with the given values}
\usage{
metric_mean_relative_error(..., normalizer, name = NULL, dtype = NULL)
}
\arguments{
\item{...}{Passed on to the underlying metric. Used for forwards and backwards compatibility.}

\item{normalizer}{The normalizer values with same shape as predictions.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
A (subclassed) \code{Metric} instance that can be passed directly to
\code{compile(metrics = )}, or used as a standalone object. See \code{?Metric} for
example usage.
}
\description{
Computes the mean relative error by normalizing with the given values
}
\details{
This metric creates two local variables, \code{total} and \code{count} that are used to
compute the mean relative error. This is weighted by \code{sample_weight}, and
it is ultimately returned as \code{mean_relative_error}:
an idempotent operation that simply divides \code{total} by \code{count}.

If \code{sample_weight} is \code{NULL}, weights default to 1.
Use \code{sample_weight} of 0 to mask values.

\if{html}{\out{<div class="sourceCode">}}\preformatted{metric = mean(|y_pred - y_true| / normalizer)
}\if{html}{\out{</div>}}

For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{m = metric_mean_relative_error(normalizer=c(1, 3, 2, 3))
m$update_state(c(1, 3, 2, 3), c(2, 4, 6, 8))
 # result     = mean(c(1, 1, 4, 5) / c(1, 3, 2, 3)) = mean(c(1, 1/3, 2, 5/3))
 #            = 5/4 = 1.25
m$result()
}\if{html}{\out{</div>}}
}
\seealso{
Other metrics: 
\code{\link{custom_metric}()},
\code{\link{metric_accuracy}()},
\code{\link{metric_auc}()},
\code{\link{metric_binary_accuracy}()},
\code{\link{metric_binary_crossentropy}()},
\code{\link{metric_categorical_accuracy}()},
\code{\link{metric_categorical_crossentropy}()},
\code{\link{metric_categorical_hinge}()},
\code{\link{metric_cosine_similarity}()},
\code{\link{metric_false_negatives}()},
\code{\link{metric_false_positives}()},
\code{\link{metric_hinge}()},
\code{\link{metric_kullback_leibler_divergence}()},
\code{\link{metric_logcosh_error}()},
\code{\link{metric_mean}()},
\code{\link{metric_mean_absolute_error}()},
\code{\link{metric_mean_absolute_percentage_error}()},
\code{\link{metric_mean_iou}()},
\code{\link{metric_mean_squared_error}()},
\code{\link{metric_mean_squared_logarithmic_error}()},
\code{\link{metric_mean_tensor}()},
\code{\link{metric_mean_wrapper}()},
\code{\link{metric_poisson}()},
\code{\link{metric_precision}()},
\code{\link{metric_precision_at_recall}()},
\code{\link{metric_recall}()},
\code{\link{metric_recall_at_precision}()},
\code{\link{metric_root_mean_squared_error}()},
\code{\link{metric_sensitivity_at_specificity}()},
\code{\link{metric_sparse_categorical_accuracy}()},
\code{\link{metric_sparse_categorical_crossentropy}()},
\code{\link{metric_sparse_top_k_categorical_accuracy}()},
\code{\link{metric_specificity_at_sensitivity}()},
\code{\link{metric_squared_hinge}()},
\code{\link{metric_sum}()},
\code{\link{metric_top_k_categorical_accuracy}()},
\code{\link{metric_true_negatives}()},
\code{\link{metric_true_positives}()}
}
\concept{metrics}
