% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCytobands.R
\name{getCytobands}
\alias{getCytobands}
\title{Add chromosome cytobands and chromosome arms to \code{TapestriExperiment}}
\usage{
getCytobands(TapestriExperiment, genome = "hg19", verbose = TRUE)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object.}

\item{genome}{Character, reference genome to use. Only hg19 is currently supported.}

\item{verbose}{Logical, if \code{TRUE} (default), progress is output as message text.}
}
\value{
\code{TapestriExperiment} object with \code{rowData} updated to include chromosome arms and cytobands.
}
\description{
\code{getCytobands()} retrieves the chromosome arm and cytoband for each probe based on stored positional data and saves them in \code{rowData}.
This is run automatically as part of \code{\link[=createTapestriExperiment]{createTapestriExperiment()}}.
Note: Some downstream smoothing and plotting functions may fail if chromosome arms are not present in \code{rowData}.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- getCytobands(tap.object, genome = "hg19")
}
\concept{build experiment}
