% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.jointmeta1SE.R
\name{confint.jointmeta1SE}
\alias{confint.jointmeta1SE}
\title{Extract confidence intervals}
\usage{
\method{confint}{jointmeta1SE}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{A jointmeta1SE object - the result of running the bootstrapping
function \code{jointmetaSE} on a jointmeta1 object}

\item{parm}{A vector indicating what parameters to return confidence
intervals for.  This should either be a vector of character strings, where
any parameters matching the supplied parameters have their estimates and
confidence intervals returned, or a numeric or integer vector of values
indicating what rows of the results of the bootstapping procedure to print
out}

\item{level}{A numerical value greater than 0 and less than 1 that indicates
the requireed level of the confidence interval.  The default is \code{level
= 0.95} giving 95\% confidence intervals.}

\item{...}{additional arguments; currently none are used.}
}
\value{
Returns the name of variables, the part of the joint model they
  relate to (sub-model, variance parameter...), their estimate and their 95\%
  confidence interval
}
\description{
\code{confint} returns the bootstrapped confidence intervals from a
\code{jointmeta1SE} object, which holds the results of bootstrapping the fit
from a \code{jointmeta1} function fit.
}
\examples{
   #change example data to jointdata object
   jointdat2<-tojointdata(longitudinal = simdat2$longitudinal,
   survival = simdat2$survival, id = 'id',longoutcome = 'Y',
   timevarying = c('time','ltime'),
   survtime = 'survtime', cens = 'cens',time = 'time')

   #set variables to factors
   jointdat2$baseline$study <- as.factor(jointdat2$baseline$study)
   jointdat2$baseline$treat <- as.factor(jointdat2$baseline$treat)

   #fit multi-study joint model
   #note: for demonstration purposes only - max.it restricted to 3
   #model would need more iterations to truely converge
   onestagefit<-jointmeta1(data = jointdat2, long.formula = Y ~ 1 + time +
                           + treat + study, long.rand.ind = c('int', 'time'),
                           long.rand.stud = c('treat'),
                           sharingstrct = 'randprop',
                           surv.formula = Surv(survtime, cens) ~ treat,
                           study.name = 'study', strat = TRUE, max.it=3)

    \dontrun{
        #calculate the SE
        onestagefitSE <- jointmetaSE(fitted = onestagefit, n.boot = 200)

        #extract confidence intervals
        confint(onestagefitSE)
    }

}
\seealso{
\code{\link{jointmeta1}}
}
