% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proptestn.h.R
\name{propTestN}
\alias{propTestN}
\title{Proportion Test (N Outcomes)}
\usage{
propTestN(data, var, counts = NULL, expected = FALSE, ratio = NULL,
  formula)
}
\arguments{
\item{data}{the data as a data frame}

\item{var}{the variable of interest in \code{data} (not necessary when
using a formula, see the examples)}

\item{counts}{the counts in \code{data}}

\item{expected}{\code{TRUE} or \code{FALSE} (default), whether expected
counts should be displayed}

\item{ratio}{a vector of numbers: the expected proportions}

\item{formula}{(optional) the formula to use, see the examples}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$props} \tab \tab \tab \tab \tab a table of the proportions \cr
  \code{results$tests} \tab \tab \tab \tab \tab a table of the test results \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$props$asDF}

\code{as.data.frame(results$props)}
}
\description{
The X² Goodness of fit test (not to be confused with the X² test of 
independence), tests the Null hypothesis that the proportions of 
observations match some expected proportions. If the p-value is low, this 
suggests that the Null hypothesis is false, and that the true proportions 
are different to those tested.
}
\examples{
data('HairEyeColor')
dat <- as.data.frame(HairEyeColor)

propTestN(formula = Freq ~ Eye, data = dat, ratio = c(1,1,1,1))

#
#  PROPORTION TEST (N OUTCOMES)
#
#  Proportions
#  --------------------------------
#    Level    Count    Proportion
#  --------------------------------
#    Brown      220         0.372
#    Blue       215         0.363
#    Hazel       93         0.157
#    Green       64         0.108
#  --------------------------------
#
#
#  X² Goodness of Fit
#  -----------------------
#    X²     df    p
#  -----------------------
#    133     3    < .001
#  -----------------------
#

}
