% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlnorm_summary.R
\name{dlnorm_summary}
\alias{dlnorm_summary}
\title{Log-normal distribution density function for summary data}
\usage{
dlnorm_summary(mu, sigma, x_mean, x_sd, x_N, log = FALSE)
}
\arguments{
\item{mu}{*Log-scale* mean of the log-normal distribution to be evaluated
(*not* the sample mean). May be a numeric scalar or vector.}

\item{sigma}{*Log-scale* standard deviation of the log-normal distribution to
be evaluated (*not* the sample SD). May be a numeric scalar or vector.}

\item{x_mean}{Sample mean (on the *natural* scale). May be a numeric scalar
or vector.}

\item{x_sd}{Sample standard deviation (on the *natural* scale). May be a
numeric scalar or vector.}

\item{x_N}{Sample number of observations. May be a numeric scalar or vector.}

\item{log}{TRUE/FALSE: Whether to return the log of the density function
(i.e., the log-likelihood). Default FALSE.}
}
\value{
A numeric scalar or vector matching the length of the longest of
  `mu`, `sigma`, `x_mean`, `x_sd`, and `x_N`.
}
\description{
Evaluates the normal distribution density function for summary data reported
as sample mean, sample SD, and sample N. Sample mean and sample SD should be
on the *natural* scale. If you have log-scale sample mean and SD (i.e., the
mean and SD of log-transformed observations),then use [dnorm_summary()]
instead.
}
\details{
`x_mean`, `x_sd`, `X_N`, `mu`, and `sigma` should either be all the same
size, or length 1. If they are different lengths, they will be repeated until
their lengths match, with a warning.
}
\author{
Caroline Ring
}
