% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_injriskmatrix.R
\name{gg_injriskmatrix}
\alias{gg_injriskmatrix}
\title{Plot risk matrices}
\usage{
gg_injriskmatrix(
  injds,
  var_type_injury = NULL,
  add_contour = TRUE,
  title = NULL,
  xlab = "Incidence (injuries per _)",
  ylab = "Mean time-loss (days) per injury",
  errh_height = 1,
  errv_width = 0.05,
  cont_max_x = NULL,
  cont_max_y = NULL,
  ...
)
}
\arguments{
\item{injds}{\code{injds} \strong{S3} object (see
\code{\link[=injsummary]{injsummary()}})}

\item{var_type_injury}{Character specifying the name of the column. A
(categorical) variable referring to the "type of injury" (e.g.
muscular/articular/others or overuse/not-overuse etc.) according to which
visualize injury summary statistics (optional, defaults to \code{NULL}).}

\item{add_contour}{Logical, whether or not to add contour lines of the
product between injury incidence and mean severity (i.e. 'incidence x
average time-loss'), which leads to injury burden (defaults to
\code{TRUE}).}

\item{title}{Text for the main title passed to
\code{\link[ggplot2:ggtitle]{ggplot2::ggtitle()}}.}

\item{xlab}{x-axis label to be passed to
\code{\link[ggplot2:xlab]{ggplot2::xlab()}}.}

\item{ylab}{y-axis label to be passed to
\code{\link[ggplot2:ylab]{ggplot2::ylab()}}.}

\item{errh_height}{Set the height of the horizontal interval whiskers; the
\code{height} argument for
\code{\link[ggplot2:geom_errorbarh]{ggplot2::geom_errorbarh()}}.}

\item{errv_width}{Set the width of the vertical interval whiskers; the
\code{width} argument for \cr
\code{\link[ggplot2:geom_errorbar]{ggplot2::geom_errorbar()}}.}

\item{cont_max_x, cont_max_y}{Numerical (optional) values indicating the
maximum on the x-axis and y-axis, respectively, to be reached by the
contour.}

\item{...}{Other arguments passed on to
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}} and
\code{\link[metR:geom_text_contour]{metR::geom_text_contour()}}.
These are often aesthetics like \code{bins = 15} or \code{breaks = 10}.}
}
\value{
A ggplot object (to which optionally more layers can be added).
}
\description{
Given an \code{injds} \strong{S3} object, it depicts risk matrix plots , a
graph in which the injury incidence (frequency) is plotted against the
average days lost per injury (consequence). The point estimate of injury
incidence together with its confidence interval is plotted, according to the
method used when running \code{\link[=injsummary]{injsummary()}} function. On
the y-axis, the mean time-loss per injury together with \eqn{\pm} IQR (days)
is plotted. The number shown inside the point and the point size itself,
report the injury burden (days lost per player-exposure time), the bigger the
size the greater the burden. See References section.
}
\examples{
\donttest{
df_exposures <- prepare_exp(raw_df_exposures, player = "player_name",
                            date = "year", time_expo = "minutes_played")
df_injuries  <- prepare_inj(raw_df_injuries, player = "player_name",
                            date_injured = "from", date_recovered = "until")
injd         <- prepare_all(data_exposures = df_exposures,
                            data_injuries  = df_injuries,
                            exp_unit = "matches_minutes")
}

\donttest{
injds <- injsummary(injd)
injds2 <- injsummary(injd, var_type_injury = "injury_type")

gg_injriskmatrix(injds)
gg_injriskmatrix(injds2, var_type_injury = "injury_type", title = "Risk matrix")
}
}
\references{
Bahr R, Clarsen B, Derman W, et al. International Olympic Committee
consensus statement: methods for recording and reporting of epidemiological
data on injury and illness in sport 2020 (including STROBE Extension for
Sport Injury and Illness Surveillance (STROBE-SIIS)) \emph{British Journal of
Sports Medicine} 2020; 54:372-389.

Fuller C. W. (2018). Injury Risk (Burden), Risk Matrices and Risk Contours
in Team Sports: A Review of Principles, Practices and Problems.\emph{Sports
Medicine}, 48(7), 1597–1606. \cr https://doi.org/10.1007/s40279-018-0913-5
}
