% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{measles_survey_df}
\alias{measles_survey_df}
\title{Measles Non-Vaccination Parent Survey}
\format{
A data frame with 307 observations and 11 variables:
\describe{
  \item{school}{Factor with 10 levels indicating the school}
  \item{form}{Factor with 2 levels indicating school form}
  \item{returnf}{Factor with 2 levels indicating if the form was returned}
  \item{consent}{Factor with 2 levels indicating if consent was given}
  \item{hadmeas}{Factor with 2 levels indicating if the child had measles}
  \item{previmm}{Factor with 2 levels indicating previous immunization}
  \item{sideeff}{Factor with 2 levels indicating concerns about side effects}
  \item{gp}{Factor with 2 levels indicating whether GP advised}
  \item{noshot}{Factor with 2 levels indicating general refusal to vaccinate}
  \item{notser}{Factor with 2 levels indicating the child was not seriously ill}
  \item{gpadv}{Factor with 2 levels indicating GP advice against immunization}
}
}
\source{
Data taken from the SDaA package version 0.1-5
}
\usage{
data(measles_survey_df)
}
\description{
This dataset, \code{measles_survey_df}, is a data frame containing the results of a survey
conducted by Roberts et al. (1995) on parents whose children had not been immunized
against measles during a recent campaign targeting all children in the first five years
of secondary school.
}
\details{
The dataset name has been kept as \code{measles_survey_df} to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix \code{_df} indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
