% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_tif}
\alias{write_tif}
\alias{tif_write}
\title{Write images in TIFF format}
\usage{
write_tif(
  img,
  path,
  bits_per_sample = "auto",
  compression = "none",
  overwrite = FALSE,
  msg = TRUE
)

tif_write(
  img,
  path,
  bits_per_sample = "auto",
  compression = "none",
  overwrite = FALSE,
  msg = TRUE
)
}
\arguments{
\item{img}{An array representing the image. \itemize{\item For a
single-plane, grayscale image, use a matrix \code{img[y, x]}. \item For a
multi-plane, grayscale image, use a 3-dimensional array \code{img[y, x, plane]}.
\item For a multi-channel, single-plane image, use a 4-dimensional array
with a redundant 4th slot \code{img[y, x, channel, ]} (see \link{ijtiff_img}
'Examples' for an example). \item For a multi-channel, multi-plane image,
use a 4-dimensional array \code{img[y, x, channel, plane]}.}}

\item{path}{file name or a raw vector}

\item{bits_per_sample}{number of bits per sample (numeric scalar). Supported
values are 8, 16, and 32. The default \code{"auto"} automatically picks the
smallest workable value based on the maximum element in \code{img}. For example,
if the maximum element in \code{img} is 789, then 16-bit will be chosen because
789 is greater than 2 ^ 8 - 1 but less than or equal to 2 ^ 16 - 1.}

\item{compression}{A string, the desired compression algorithm. Must be one
of \code{"none"}, \code{"LZW"}, \code{"PackBits"}, \code{"RLE"}, \code{"JPEG"}, \code{"deflate"} or
\code{"Zip"}. If you want compression but don't know which one to go for, I
recommend \code{"Zip"}, it gives a large file size reduction and it's lossless.
Note that \code{"deflate"} and \code{"Zip"} are the same thing. Avoid using \code{"JPEG"}
compression in a TIFF file if you can; I've noticed it can be buggy.}

\item{overwrite}{If writing the image would overwrite a file, do you want to
proceed?}

\item{msg}{Print an informative message about the image being written?}
}
\value{
The input \code{img} (invisibly).
}
\description{
Write images into a TIFF file.
}
\examples{
img <- read_tif(system.file("img", "Rlogo.tif", package = "ijtiff"))
temp_dir <- tempdir()
write_tif(img, paste0(temp_dir, "/", "Rlogo"))
img <- matrix(1:4, nrow = 2)
write_tif(img, paste0(temp_dir, "/", "tiny2x2"))
list.files(temp_dir, pattern = "tif$")
}
\seealso{
\code{\link[=read_tif]{read_tif()}}
}
\author{
Simon Urbanek wrote most of this code for the 'tiff' package. Rory
Nolan lifted it from there and changed it around a bit for this 'ijtiff'
package. Credit should be directed towards Lord Urbanek.
}
