% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractWCdata.R
\name{extractWCdata}
\alias{extractWCdata}
\title{Extracting World Climatic Data}
\usage{
extractWCdata(sites, long, lat, var, res = 2.5)
}
\arguments{
\item{sites}{object of class "data.frame" with coordinates of sites from which to extract data.}

\item{long}{character. Name of column from \code{sites} with longitude.}

\item{lat}{character. Name of column from \code{sites} with latitude.}

\item{var}{character. Climatic variable(s) to be extracted: 'tavg', 'tmin', 'tmax', 'prec', 'bio', 'srad', 'vapr', 'wind'}

\item{res}{numeric. Spatial resolution. Default 2.5}
}
\value{
An object of class "data.frame" with specified climatic variables for coordinates in \code{sites}.
}
\description{
extractWCdata returns a data frame based on specified climatic variables.
}
\details{
A grid can be created with any particular coordinates and used as input for \code{sites} (see section 'Examples'). \code{extractWCdata} will use the given coordinates to extract data from the WorldClim2.1 database.
The extracted data will most likely contain NA's for sites where climatic data is not available. These should be removed or imputed before using the data to make predictions.
}
\examples{
if(interactive()){
 # Create grid
 sp1 <- seq(-16, 115, length = 10)
 sp2 <- seq(25, 59, length = 10)
 sp <- expand.grid(x = sp1, y = sp2)

 # Extract data using grid
 sp.df0 <- extractWCdata(sp, long = 'x', lat = 'y', var = 'tavg')
 sp.df <- na.omit(sp.df0)
 }
}
\author{
Zakaria Kehel, Fawzy Nawar, Bancy Ngatia, Khadija Aouzal
}
