% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_utils.R
\name{segmentStats}
\alias{segmentStats}
\title{Summary statistics for identified segments}
\usage{
segmentStats(
  x,
  quantiles = c(0.025, 0.5, 0.975),
  returnAll = FALSE,
  unit = "mb"
)
}
\arguments{
\item{x}{A list of matrices produced with \code{\link[=findPattern]{findPattern()}}.}

\item{quantiles}{A vector of quantiles to include in the summary.}

\item{returnAll}{A logical, by default FALSE. If TRUE, the output includes a
vector \code{allSegs} containing the lengths of all segments in all simulations.}

\item{unit}{Either "mb" (megabases) or "cm" (centiMorgan); the length unit
for genomic segments.}
}
\value{
A list containing a data frame \code{perSim}, a matrix \code{summary} and (if
\code{returnAll} is TRUE) a vector \code{allSegs}.

Variables used in the output:
\itemize{
\item \code{Count}: The total number of segments in a simulation
\item \code{Total}: The total sum of the segment lengths in a simulation
\item \code{Average}: The average segment lengths in a simulation
\item \code{Shortest}: The length of the shortest segment in a simulation
\item \code{Longest}: The length of the longest segment in a simulation
\item \code{Overall} (only in \code{summary}): A summary of all segments from all
simulations
}
}
\description{
Compute summary statistics for segments identified by \code{\link[=findPattern]{findPattern()}}.
}
\examples{
x = nuclearPed(3)
sims = ibdsim(x, N = 2, map = uniformMap(M = 2), model = "haldane", seed = 1729)

# Segments where all siblings carry the same allele
segs = findPattern(sims, pattern = list(carriers = 3:5))

# Summarise
segmentStats(segs, unit = "mb")

# The unit does not matter in this case (since the map is trivial)
segmentStats(segs, unit = "cm")

}
\seealso{
\code{\link[=findPattern]{findPattern()}}
}
