% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethCl_CS_Arbitrary.R
\name{flow_depth}
\alias{flow_depth}
\alias{flow_depth,CSarbitrary-method}
\alias{flow_depth,CScircle-method}
\title{Flow Depth}
\usage{
flow_depth(object, Q, J, method = "Strickler", ret = "all", plot = FALSE)
}
\arguments{
\item{object}{A CSarbitrary or CScircle object.}

\item{Q}{Discharge [m3/s].}

\item{J}{Bottom slope [-].}

\item{method}{Method to calculate the roughness. Allowed are "Strickler"
(equal roughness) "Einstein" (mean roughness) and "Prandtl-Coolebrook-White".}

\item{ret}{Defines the result returned by the function.}

\item{plot}{Logical; if `TRUE`, plots the results.}
}
\value{
A list containing the following hydraulic variables:
\describe{
  \item{h}{Flow depth [m].}
  \item{v}{Flow velocity [m/s].}
  \item{Fr}{Froude number [-].}
  \item{kSt_m}{Mean roughness [m^(1/3)/s] (if method = "Einstein").}
  \item{A}{Wetted area [m^2].}
  \item{P}{Wetted perimeter [m].}
}
}
\description{
Calculates the flow depth of a CSarbitrary or CScircle object for
  a given discharge and bottom slope under uniform flow conditions.
}
\examples{
# Example for CSarbitrary object
x <- c(0, 4, 9, 13)
z <- c(2, 0, 0, 2)
cs <- CSarbitrary(
  x = x, z = z, xb_l = 4, xb_r = 9,
  kSt_B = 35, kSt_l = 45, kSt_r = 45
)
flow_depth(cs, Q = 8.677, J = 0.0001, method = "Einstein", ret = "h")
flow_depth(cs, Q = 8.677, J = 0.0001, method = "Einstein", plot = TRUE)

# Example for CScircle object
csC <- CScircle(Di = 0.7, ks = 1.5, kSt = 75)
flow_depth(csC, Q = 0.46, J = 0.004)
flow_depth(csC, Q = 0.46, J = 0.004, method = "Prandtl-Coolebrook-White", plot = TRUE)

}
