% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glance.mlm.R
\name{glance.mlm}
\alias{glance.mlm}
\title{Glance at an mlm object}
\usage{
\method{glance}{mlm}(x, ...)
}
\arguments{
\item{x}{An \code{"mlm"} object created by \code{\link[stats]{lm}}, i.e., with a multivariate response.}

\item{...}{Additional arguments. Not used.}
}
\value{
A \code{\link[tibble]{tibble}} with one row for each response variable and the columns:
\describe{
  \item{\code{r.squared}}{R squared statistic, or the percent of variation explained by the model.}
  \item{\code{sigma}}{Estimated standard error of the residuals}
  \item{\code{fstatitic}}{Overall F statistic for the model}
  \item{\code{numdf}}{Numerator degrees of freedom for the overall test}
  \item{\code{dendf}}{Denominator degrees of freedom for the overall test}
  \item{\code{p.value}}{P-value corresponding to the F statistic}
  \item{\code{nobs}}{Number of observations used}
}
}
\description{
This function takes an "mlm" object, fit by \code{\link[stats]{lm}} with a multivariate response.
The goal is to return something analogous to \code{\link[broom]{glance.lm}} for a univariate response linear model.
}
\details{
In the multivariate case, it returns a \code{\link[tibble]{tibble}} with one row for each
response variable, containing goodness of fit measures, F-tests and p-values.
}
\examples{
iris.mod <- lm(cbind(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width) ~ Species, data=iris)
glance(iris.mod)
}
\keyword{multivariate}
