% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_lasso_early_stopping.R
\name{cv_lasso_early_stopping}
\alias{cv_lasso_early_stopping}
\title{Cross-validated LASSO on Indicator Bases}
\usage{
cv_lasso_early_stopping(x_basis, y, n_lambda = 100, n_folds = 10)
}
\arguments{
\item{x_basis}{A \code{dgCMatrix} object corresponding to a sparse matrix of
the basis functions generated for the HAL algorithm.}

\item{y}{A \code{numeric} vector of the observed outcome variable values.}

\item{n_lambda}{A \code{numeric} scalar indicating the number of values of
the L1 regularization parameter (lambda) to be obtained from fitting the
LASSO to the full data. Cross-validation is used to select an optimal
lambda (that minimizes the risk) from among these.}

\item{n_folds}{A \code{numeric} scalar for the number of folds to be used in
the cross-validation procedure to select an optimal value of lambda.}
}
\description{
Fits the LASSO regression using a customized procedure with cross-validation
based on \pkg{origami}
}
