% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_categorical.R
\name{plot_categorical}
\alias{plot_categorical}
\title{Plot a categorical variable by sub-groups}
\usage{
plot_categorical(
  data,
  outcome,
  na.rm = TRUE,
  by = NULL,
  drop_na_by = FALSE,
  convert_continuous = TRUE,
  ...,
  show_overall = TRUE,
  overall_label = "Overall",
  show_pvalues = TRUE,
  pvalues_test = c("fisher", "chisq"),
  pvalues_labeller = scales::label_pvalue(add_p = TRUE),
  pvalues_size = 3.5,
  pvalues_y = ifelse(flip, 1.05, 1),
  show_labels = TRUE,
  labels_labeller = scales::label_percent(1),
  labels_size = 3.5,
  labels_color = "auto",
  facet_labeller = ggplot2::label_wrap_gen(width = 50, multi_line = TRUE),
  flip = FALSE,
  minimal = FALSE,
  return_data = FALSE
)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{outcome}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of
categorical variables to be plotted.}

\item{na.rm}{Should \code{NA} values be removed from the \code{outcome}?}

\item{by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of variables to
group by (comparison is done separately for each variable).}

\item{drop_na_by}{Remove \code{NA} values in \code{by} variables?}

\item{convert_continuous}{Should continuous by variables (with 5 unique
values or more) be converted to quartiles (using \code{cut_quartiles()})?}

\item{...}{Additional arguments passed to \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}.}

\item{show_overall}{Display "Overall" column?}

\item{overall_label}{Label for the overall column.}

\item{show_pvalues}{Display p-values in the top-left corner?}

\item{pvalues_test}{Test to compute p-values for data frames: \code{"fisher"} for
\code{\link[stats:fisher.test]{stats::fisher.test()}} (with \code{simulate.p.value = TRUE}) or \code{"chisq"} for
\code{\link[stats:chisq.test]{stats::chisq.test()}}. Has no effect on survey objects for those
\code{\link[survey:svychisq]{survey::svychisq()}} is used.}

\item{pvalues_labeller}{Labeller function for p-values.}

\item{pvalues_size}{Text size for p-values.}

\item{pvalues_y}{Y position of p-values.}

\item{show_labels}{Display proportion labels?}

\item{labels_labeller}{Labeller function for labels.}

\item{labels_size}{Size of labels.}

\item{labels_color}{Color of labels.}

\item{facet_labeller}{Labeller function for strip labels.}

\item{flip}{Flip x and y axis?}

\item{minimal}{Should a minimal theme be applied? (no y-axis, no grid)}

\item{return_data}{Return computed data instead of the plot?}
}
\description{
Plot one or several categorical variables by sub-groups. See \code{\link[=proportion]{proportion()}}
for more details on the way proportions and confidence intervals are
computed. Return a bar plot (see examples).
}
\examples{
titanic |>
  plot_categorical(
    Class,
    by = c(Age, Sex)
  )

\donttest{
titanic |>
  plot_categorical(
    Class,
    by = c(Age, Sex),
    show_overall = FALSE,
    flip = TRUE
  )

titanic |>
  plot_categorical(
    Class,
    by = c(Age, Sex),
    flip = TRUE,
    minimal = TRUE
  )
}
\dontshow{if (rlang::is_installed("gtsummary")) withAutoprint(\{ # examplesIf}
\donttest{
gtsummary::trial |>
  plot_categorical(grade, by = c(age, stage, trt))
gtsummary::trial |>
  plot_categorical(grade, by = c(age, stage, trt), drop_na_by = TRUE)
gtsummary::trial |>
  plot_categorical(c(grade, stage), by = c(trt, response))
}
\dontshow{\}) # examplesIf}
}
\keyword{hplot}
