% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multiple_answers.R
\name{plot_multiple_answers}
\alias{plot_multiple_answers}
\alias{plot_multiple_answers_dodge}
\title{Plot a multiple answers question}
\usage{
plot_multiple_answers(
  data,
  answers = dplyr::everything(),
  value = NULL,
  by = NULL,
  combine_answers = FALSE,
  combine_sep = " | ",
  missing_label = " missing",
  none_label = "none",
  drop_na = FALSE,
  sort = c("none", "ascending", "descending", "degrees"),
  geom = "bar",
  ...,
  show_ci = TRUE,
  conf_level = 0.95,
  ci_color = "black",
  show_labels = TRUE,
  labels_labeller = scales::label_percent(1),
  labels_size = 3.5,
  labels_color = "black",
  flip = FALSE,
  return_data = FALSE
)

plot_multiple_answers_dodge(
  data,
  answers = dplyr::everything(),
  value = NULL,
  by,
  combine_answers = FALSE,
  combine_sep = " | ",
  missing_label = " missing",
  none_label = "none",
  drop_na = FALSE,
  sort = c("none", "ascending", "descending", "degrees"),
  geom = c("bar", "point"),
  width = 0.75,
  ...,
  show_ci = TRUE,
  conf_level = 0.95,
  ci_color = "black",
  show_labels = TRUE,
  labels_labeller = scales::label_percent(1),
  labels_size = 3.5,
  labels_color = "black",
  flip = FALSE
)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{answers}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of variables
identifying the different answers of the question.}

\item{value}{Value indicating a positive answer. By default, will use the
maximum observed value and will display a message.}

\item{by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optional list of
variables to compare (using facets).}

\item{combine_answers}{Should answers be combined? (see examples)}

\item{combine_sep}{Character string to separate combined answers.}

\item{missing_label}{When combining answers and
\code{drop_na = FALSE}, label for missing values.}

\item{none_label}{When combining answers and \code{flip = TRUE},
label when no item is selected.}

\item{drop_na}{Should any observation with a least one \code{NA} value be dropped?}

\item{sort}{Should answers be sorted according to their proportion? They
could also be sorted by degrees (number of elements) when combining answers.}

\item{geom}{Geometry to use for plotting proportions (\code{"bar"} by default).}

\item{...}{Additional arguments passed to the geom defined by \code{geom}.}

\item{show_ci}{Display confidence intervals?}

\item{conf_level}{Confidence level for the confidence intervals.}

\item{ci_color}{Color of the error bars representing confidence intervals.}

\item{show_labels}{Display proportion labels?}

\item{labels_labeller}{Labeller function for proportion labels.}

\item{labels_size}{Size of proportion labels.}

\item{labels_color}{Color of proportion labels.}

\item{flip}{Flip x and y axis?}

\item{return_data}{Return computed data instead of the plot?}

\item{width}{Dodging width.}
}
\description{
Considering a multiple answers question coded as several binary variables
(one per answer), plot the proportion of positive answers.
If \code{combine_answers = FALSE}, plot the proportion of positive answers of each
item, separately. If \code{combine_answers = FALSE}, combine the different answers
(see \code{\link[=combine_answers]{combine_answers()}}) and plot the proportion of each combination
(\code{\link[ggupset:axis_combmatrix]{ggupset}} package required when
\code{flip = FALSE}).
See \code{\link[=proportion]{proportion()}} for more details on the way proportions and
confidence intervals are computed. By default, return a bar plot, but other
geometries could be used (see examples). If defined, use variable labels
(see examples).
}
\note{
If \code{drop_na = TRUE}, any observation with at least one \code{NA} value for one
item will be dropped.
If \code{drop_na = FALSE} and \code{combine_answers = FALSE}, \code{NA} values for a
specific answer are excluded the denominator when computing
proportions. Therefore, all proportions may be computed on different
population sizes.
If \code{drop_na = FALSE} and \code{combine_answers = TRUE}, any observation with at
least one \code{NA} value will be labeled with \code{missing_label}.
}
\examples{
d <-
  dplyr::tibble(
    q1a = sample(c("y", "n"), size = 200, replace = TRUE),
    q1b = sample(c("y", "n", "n", NA), size = 200, replace = TRUE),
    q1c = sample(c("y", "y", "n"), size = 200, replace = TRUE),
    q1d = sample("n", size = 200, replace = TRUE)
  )

d |> plot_multiple_answers(q1a:q1c)

d |>
  labelled::set_variable_labels(
    q1a = "apple",
    q1b = "banana",
    q1c = "chocolate",
    q1d = "Dijon mustard"
  ) |>
  plot_multiple_answers(
    value = "y",
    drop_na = TRUE,
    sort = "desc",
    fill = "lightblue",
    flip = TRUE
  )
\dontshow{if (rlang::is_installed("ggupset")) withAutoprint(\{ # examplesIf}
\donttest{
d |>
  plot_multiple_answers(
    combine_answers = TRUE,
    value = "y",
    fill = "#DDCC77",
    drop_na = TRUE
  )

d |>
  plot_multiple_answers(
    combine_answers = TRUE,
    value = "y",
    flip = TRUE,
    mapping = ggplot2::aes(fill = prop),
    show.legend = FALSE
  ) +
  ggplot2::scale_fill_distiller(palette = "Spectral")

d$group <- sample(c("group A", "group B"), size = 200, replace = TRUE)
d |>
  plot_multiple_answers(
    answers = q1a:q1d,
    by = group,
    combine_answers = TRUE,
    sort = "degrees",
    value = "y",
    fill = "grey80"
  )

d |>
  plot_multiple_answers_dodge(q1a:q1d, by = group)
d |>
  plot_multiple_answers_dodge(q1a:q1d, by = group, flip = TRUE)
d |>
  plot_multiple_answers_dodge(q1a:q1d, by = group, combine_answers = TRUE)
}
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed(c("ggupset", "ggstats"))) withAutoprint(\{ # examplesIf}
\dontshow{\}) # examplesIf}
}
\keyword{hplot}
