% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_gtfs.R
\name{read_files}
\alias{read_files}
\title{Read a GTFS text file}
\usage{
read_files(file, gtfs_standards, fields, extra_spec, tmpdir, quiet, encoding)
}
\arguments{
\item{file}{A string. The name of the file (without \code{.txt} extension) to
be read.}

\item{gtfs_standards}{A named list. Created by
\code{\link{get_gtfs_standards}}.}

\item{fields}{A named list. Passed by the user to \code{\link{import_gtfs}}.}

\item{extra_spec}{A named list. Passed by the user to
\code{\link{import_gtfs}}.}

\item{tmpdir}{A string. The path to the temporary folder where GTFS text
files were unzipped to.}

\item{quiet}{Whether to hide log messages and progress bars (defaults to
TRUE).}

\item{encoding}{A string. Passed to \code{\link[data.table]{fread}}, defaults
to \code{"unknown"}. Other possible options are \code{"UTF-8"} and
\code{"Latin-1"}. Please note that this is not used to re-encode the input,
but to enable handling encoded strings in their native encoding.}
}
\value{
A \code{data.table} representing the desired text file according to
  the standards for reading and writing GTFS feeds with R.
}
\description{
Reads a GTFS text file from the main \code{.zip} file.
}
\seealso{
\code{\link{get_gtfs_standards}}
}
\keyword{internal}
