% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-generics.R
\name{sum_squares}
\alias{sum_squares}
\alias{sum_squares.default}
\alias{sum_squares.matrix}
\alias{sum_squares.FitLandDF}
\title{Sum of Squares Metric for a GLCM}
\usage{
sum_squares(x, ...)

\method{sum_squares}{default}(x, ...)

\method{sum_squares}{matrix}(x, ...)

\method{sum_squares}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{gray-level co-occurrence matrix}

\item{...}{additional parameters}

\item{nlevels}{desired number of discrete gray levels}
}
\value{
double
}
\description{
Calculate the sum of squares feature or metric for a gray-level co-occurrence
matrix. For definition and application, see Lofstedt et al. (2019)
\doi{10.1371/journal.pone.0212110}.
}
\examples{
## calculate sum of squares of arbitrary GLCM
# define arbitrary GLCM
x <- matrix(1:16, nrow = 4)

# normalize
n_x <- normalize_glcm(x)

# calculate sum of squares
sum_squares(n_x)

## calculate sum of squares of arbitrary fitness landscape
# create fitness landscape using FitLandDF object
vals <- runif(64)
vals <- array(vals, dim = rep(4, 3))
my_landscape <- fitscape::FitLandDF(vals)

# calculate sum of squares of fitness landscape, assuming 2 discrete gray levels
sum_squares(my_landscape, nlevels = 2)

## confirm value of sum of squares for fitness landscape
# extract normalized GLCM from fitness landscape
my_glcm <- get_comatrix(my_landscape, discrete = equal_discrete(2))

# calculate sum of squares of extracted GLCM
sum_squares(my_glcm)  # should match value of above sum_squares function call
}
