% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variant.R
\name{get_variant}
\alias{get_variant}
\title{Get Variant}
\usage{
get_variant(
  snpId = NULL,
  variantId = NULL,
  datasetId = "gtex_v8",
  chromosome = NULL,
  poss = NULL,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{snpId}{String}

\item{variantId}{String. A gtex variant ID.}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{chromosome}{String. One of "chr1", "chr2", "chr3", "chr4", "chr5",
"chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13",
"chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21",
"chr22", "chrM", "chrX", "chrY".}

\item{poss}{Integer, vector.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
This service returns information about a variant, including
position, dbSNP RS ID, the reference allele, the alternative allele, and
whether the minor allele frequency is >= 1\%. For GTEx v6p, there is also
information about whether the whole exome sequence and chip sequencing data
are available. Results may be queried by GTEx variant ID (variantId), dbSNP
RS ID (snpId) or genomic location (chromosome and pos). Variants are
identified based on the genotype data of each dataset cohort, namely, are
dataset-dependent. Each variant is assigned a unique GTEx variant ID (i.e.
the primary key). Not all variants have a mappable dbSNP RS ID. By default,
this service queries the latest GTEx release.

\href{https://gtexportal.org/api/v2/redoc#tag/Datasets-Endpoints/operation/get_variant_api_v2_dataset_variant_get}{GTEx Portal API documentation}
}
\examples{
# search by rsid
get_variant(snpId = "rs1410858")

# search by variantId
get_variant(variantId = "chr1_153209640_C_A_b38")

# search by chromosome and position
get_variant(
  chromosome = "chr1",
  pos = 153209600:153209700
)
}
\seealso{
Other Datasets Endpoints: 
\code{\link{get_annotation}()},
\code{\link{get_collapsed_gene_model_exon}()},
\code{\link{get_downloads_page_data}()},
\code{\link{get_file_list}()},
\code{\link{get_full_get_collapsed_gene_model_exon}()},
\code{\link{get_functional_annotation}()},
\code{\link{get_linkage_disequilibrium_by_variant_data}()},
\code{\link{get_linkage_disequilibrium_data}()},
\code{\link{get_sample_datasets}()},
\code{\link{get_subject}()},
\code{\link{get_tissue_site_detail}()},
\code{\link{get_variant_by_location}()}
}
\concept{Datasets Endpoints}
