% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_district_text.R
\docType{data}
\name{geom_district_text}
\alias{geom_district_text}
\alias{geom_district_label}
\alias{stat_district_coordinates}
\alias{StatDistrictCoordinates}
\alias{GeomDistrictText}
\title{Label Map Regions}
\usage{
geom_district_text(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  adjust = 1,
  check_overlap = FALSE,
  parse = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_district_label(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  label.padding = ggplot2::unit(0.25, "lines"),
  label.r = ggplot2::unit(0.15, "lines"),
  label.size = 0.25,
  check_overlap = FALSE,
  parse = FALSE,
  adjust = 1,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_district_coordinates(
  mapping = NULL,
  data = NULL,
  geom = "text",
  position = "identity",
  na.rm = FALSE,
  adjust = 1,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}}

\item{data}{The data to be displayed in this layer}

\item{position}{Position adjustment}

\item{na.rm}{if \code{TRUE}, will silently remove missing values from calculations}

\item{adjust}{A multiplicative scaling factor for the default label sizes}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the same
layer will not be plotted.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{\link[grDevices:plotmath]{?plotmath}}.}

\item{show.legend}{Should this layer be included in the legends?}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them.}

\item{...}{Passed onto the underlying geoms.}

\item{label.padding}{Padding around label}

\item{label.r}{Radius of rounded corners}

\item{label.size}{Size of label border (mm)}

\item{geom}{The geometric object to use display the data}
}
\value{
a \code{ggproto} object
}
\description{
Aggregates shapefile according to the \code{group} aesthetic and positions labels
for each region defined by \code{group}. By default, labels will be sized in rough
proportion to the available area.
}
\examples{
library(ggplot2)
data(oregon)

ggplot(oregon, aes(group=county)) +
    geom_district() +
    geom_district_text() +
    scale_fill_randmcnally() +
    theme_map()

ggplot(oregon, aes(group=cd_2020)) +
  geom_district(lwd=0.9, color="#442222") +
  geom_district(aes(group=county), lwd=0.4, lty="dashed", fill=NA) +
  geom_district_text(aes(group=county, label=toupper(county)),
                     size=2.2, check_overlap=TRUE) +
  geom_district_text(adjust=2) +
  scale_fill_penn82() +
  theme_map()

}
\concept{geoms}
\keyword{datasets}
