% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship2_alignped4.R
\name{kinship2_alignped4}
\alias{kinship2_alignped4}
\title{Compute optimal horizontal spacing for pedigree alignment}
\usage{
kinship2_alignped4(rval, spouse, level, width, align)
}
\arguments{
\item{rval}{Aligned pedigree structure from previous alignment steps}

\item{spouse}{Logical matrix indicating spouse connections}

\item{level}{Integer vector of generation levels}

\item{width}{Numeric, maximum width of the pedigree plot}

\item{align}{Logical or numeric vector. If logical, uses default alignment parameters.
If numeric, should be a vector c(a1, a2) where a1 controls parent-child penalties
and a2 controls spouse penalties}
}
\value{
Matrix of optimized horizontal positions for each subject
}
\description{
This is an internal helper function for pedigree alignment. It uses quadratic
programming to find optimal horizontal positions for subjects that minimize
the distance between parents and children while keeping spouses together and
respecting spacing constraints. Requires the quadprog package.
}
\keyword{internal}
