% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeHelpers.R
\name{countSiblings}
\alias{countSiblings}
\title{Count siblings of each individual}
\usage{
countSiblings(ped, personID = "ID", momID = "momID", dadID = "dadID")
}
\arguments{
\item{ped}{A data frame containing the pedigree information}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}
}
\value{
A data frame with an additional column, siblings,
       that contains the number of siblings for each individual
}
\description{
Count siblings of each individual
}
\examples{
library(BGmisc)
data("potter")
countSiblings(potter, personID = "personID")

}
