% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_checks.R
\name{check_numeric}
\alias{check_numeric}
\title{Check input numeric arguments for class and length.}
\usage{
check_numeric(
  ...,
  allow_null = FALSE,
  allowed_lengths = 1,
  list_allowed = FALSE,
  call = NULL
)
}
\arguments{
\item{...}{Should be a single named argument, where the name is the variable name displayed in the error message.
The value is the (supposed) logical.}

\item{allow_null}{Logical indicating if NULL is allowed as input for the argument.}

\item{allowed_lengths}{The allowed lengths of the argument.}

\item{list_allowed}{Logical indicating if the argument is allowed to be a list. If TRUE each element will be checked.}

\item{call}{Call to use for the call in the error message (used in rlang::abort).
Default is rlang::caller_env() resulting in the function that called check_logical().}
}
\value{
Error if not numeric, NULL when not allowed, or too long/too short.
}
\description{
Check input numeric arguments for class and length.
}
\keyword{internal}
