% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-report.R
\name{pmx_report}
\alias{pmx_report}
\title{Generates ggpmX report from a pre-defined template}
\usage{
pmx_report(
  contr,
  name,
  save_dir,
  plots_subdir = "ggpmx_GOF",
  output = c("all", "plots", "report"),
  template = "standing",
  footnote = output == "all",
  edit = FALSE,
  format = NULL,
  title,
  ...
)
}
\arguments{
\item{contr}{\code{pmxClass} controller}

\item{name}{\code{character} The report name}

\item{save_dir}{Output directory. A directory to write the results files to}

\item{plots_subdir}{Output folder name, ggpmx_GOF by default}

\item{output}{\code{character} the result type, can be \cr
a standalone directory of plots or a report document as defined in the template \cr
(pdf, docx,..) ,or both}

\item{template}{\code{character} ggPMX predefined template or the
path to a custom rmarkdown template. \cr
Use \code{\link{pmx_report_template}} to get the list
of available templates}

\item{footnote}{\code{logical}  TRUE to add a footnote to the generated plots. The default footnote is to add \cr
the path where the plot is saved.}

\item{edit}{\code{logical}  TRUE to edit the template immediately}

\item{format}{\code{character} The output document format. By default, a word report is generated. \cr
User can specify one or more formats from c("word","pdf","html","all"). format "all" to generate all formats.}

\item{title}{\code{character} report title (optional)}

\item{...}{extra parameters depending in the template used}
}
\description{
Generates ggpmX report from a pre-defined template
}
\details{
\code{pmx_report} uses pre-defined template .Rmd to generate the report.
The idea is to pass the controller as a report argument using knitr \code{params} artifact.
}
\examples{
\donttest{

library(ggPMX)
# you probably want to create the report in your own directory
# But using a temp directory allows for easy cleanup

## case1: generate a single report
withr::with_tempdir({
  ctr <- theophylline()
  ctr \%>\% pmx_report(
    name = "my_report",
    save_dir = getwd(),
    output="report"
  )
})


## case2: generate standalone plots
withr::with_tempdir({
  ctr <- theophylline()
  ctr \%>\% pmx_report(
    name = "my_report",
    save_dir = getwd(),
    output="plots"
  )
})


## case3: generate both : reports + plots
## by default add footnote
## Note, you can force footnote to FALSE using footnote parameter
withr::with_tempdir({
  ctr <- theophylline()
  ctr \%>\% pmx_report(
    name="my_report",
    save_dir=getwd(),
    output="all"
  )
})


## case4 : generate standalone plots with footnotes
withr::with_tempdir({
  ctr <- theophylline()
  ctr \%>\% pmx_report(
    name="my_report",
    save_dir=getwd(),
    footnote=TRUE,
    output="plots"
  )
})


##  case6: dynamic edit
## uncomment to run
# ctr <- theophylline()
# ctr \%>\% pmx_report(
#   save_dir = file.path(getwd(),"case6"),
#   name="my_report",
#   output="report",
#   edit = TRUE)


## case7 : generate individual plots report
## ctr <- theophylline()
## ctr \%>\% pmx_report(
##   name="report2",
##   save_dir = getwd(),
##   template="individual",
##   format="all",
##   which_pages=1:2
## )
}
}
