% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive.R
\name{gfilmmPredictive}
\alias{gfilmmPredictive}
\title{Generalized fiducial predictive distributions}
\usage{
gfilmmPredictive(gfi, newdata)
}
\arguments{
\item{gfi}{a \code{\link{gfilmm}} object}

\item{newdata}{dataframe in which to look for variables with which to 
predict, or \code{NULL} if the model is an intercept-only model without 
random effect}
}
\value{
A list with two fields: \code{FPD}, a dataframe containing the 
  simulations, and \code{WEIGHT}, their weight. This is a \code{gfilmm} 
  object.
}
\description{
Simulations of the generalized fiducial predictive 
  distributions.
}
\note{
Actually the levels of the random effects given in \code{newdata} can 
  be different from the original levels. For instance, in the example 
  provided below, we enter \code{block = c("4","6")}, but we could also 
  enter \code{block = c("A","B")}, even though \code{"A"} and \code{"B"} 
  are not some levels of the \code{block} factor. Both options only mean 
  that the two observations to predict are in two different blocks.
}
\examples{
gfi <- gfilmm(~ cbind(yield-0.1, yield+0.1), ~ N, ~ block, npk, 2000)
fpd <- gfilmmPredictive(gfi, data.frame(N = c("0","1"), block = c("4","6")))
gfiSummary(fpd)
}
