% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g6.R
\name{g6}
\alias{g6}
\title{Create a G6 Graph Visualization}
\usage{
g6(
  nodes = NULL,
  edges = NULL,
  combos = NULL,
  jsonUrl = NULL,
  iconsUrl = "//at.alicdn.com/t/font_2678727_za4qjydwkkh.js",
  width = "100\%",
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{nodes}{A data frame or list of nodes in the graph. Each node should have at least
an "id" field. See 'Data Structure' section for more details.
Default: NULL.}

\item{edges}{A data frame or list of edges in the graph. Each edge should have "source"
and "target" fields identifying the connected nodes. See 'Data Structure' section
for more details.
Default: NULL.}

\item{combos}{A data frame or list of combo groups in the graph. Each combo should have
at least an "id" field. Nodes can be assigned to combos using their "combo" field.
See 'Data Structure' section for more details.
Default: NULL.}

\item{jsonUrl}{An url pointing to a valid JSON containing the graph data in G6 format.
See \url{https://assets.antv.antgroup.com/g6/20000.json} for
an example. Can't be used at the same time as \code{nodes}, \code{edges}, and \code{combos}.}

\item{iconsUrl}{A URL pointing to a JavaScript file containing custom icons. Default provides
reasonable set of icons from
\url{https://at.alicdn.com/t/project/2678727/caef142c-804a-4a2f-a914-ae82666a31ee.html?spm=a313x.7781069.1998910419.35}.}

\item{width}{Width of the graph container in pixels or as a valid CSS unit.
Default: NULL (automatic sizing).}

\item{height}{Height of the graph container in pixels or as a valid CSS unit.
Default: NULL (automatic sizing).}

\item{elementId}{A unique ID for the graph HTML element.
Default: NULL (automatically generated).}
}
\value{
An htmlwidget object that can be printed, included in R Markdown documents,
or used in Shiny applications. This widget contains the graph data and configuration
necessary to render the G6 graph visualization.
}
\description{
Creates an interactive graph visualization using the G6 graph visualization library.
This function is the main entry point for creating G6 graph visualizations in R.
}
\details{
The \code{g6} function creates a G6 graph as an htmlwidget that can be used in R Markdown,
Shiny applications, or rendered to HTML. It takes graph data in the form of nodes, edges,
and optional combo groupings, along with various configuration options for customizing
the appearance and behavior of the graph.

\subsection{Nodes}{
The \code{nodes} parameter should be a data frame or list of nodes with at least an \code{id} field
for each node. Additional fields can include:
\itemize{
\item \code{id} (required): Unique identifier for the node. Must be a character.
\item \code{type}: Node type (e.g., "circle", "rect", "diamond").
\item \code{data}: Custom data associated with the node.
\item \code{style}: List of style attributes (color, size, etc.).
\item \code{states}: String. Initial states for the node, such as selected, active, hover, etc.
\item \code{combo}: ID of the combo this node belongs to.
}}

\subsection{Edges}{
The \code{edges} parameter should be a data frame or list of edges with at least \code{source} and
\code{target} fields identifying the connected nodes. Additional fields can include:
\itemize{
\item \code{source} (required): ID of the source node. Must be a character.
\item \code{target} (required): ID of the target node. Must be a character.
\item \code{id}: Unique identifier for the edge.
\item \code{type}: Edge type (e.g., "line", "cubic", "arc").
\item \code{data}: Custom data associated with the edge.
\item \code{style}: List of style attributes (color, width, etc.).
\item \code{states}: String. Initial states for the edge.
}}

\subsection{Combos}{
The \code{combos} parameter is used for grouping nodes and can be a data frame or list with
combo definitions. Fields include:
\itemize{
\item \code{id} (required): Unique identifier for the combo. Must be a character.
\item \code{type}: String: Combo type. It can be the type of built-in Combo, or the custom Combo.
\item \code{data}: Custom data associated with the combo.
\item \code{style}: List of style attributes.
\item \code{states}: String. Initial states for the combo.
\item \code{combo}: String. Parent combo ID. If there is no parent combo, it is null.
}}

Nodes are assigned to combos by setting their \code{combo} field to the ID of the combo.
}
\examples{
# Create a simple graph with two nodes and one edge
nodes <- data.frame(
  id = c("node1", "node2")
)

edges <- data.frame(
  source = "node1",
  target = "node2"
)

g6(nodes = nodes, edges = edges)
}
